/*
 * Decompiled with CFR 0.152.
 */
package maxhyper.dtbwg.growthlogic;

import com.ferreusveritas.dynamictrees.api.configuration.ConfigurationProperty;
import com.ferreusveritas.dynamictrees.growthlogic.GrowthLogicKit;
import com.ferreusveritas.dynamictrees.growthlogic.GrowthLogicKitConfiguration;
import com.ferreusveritas.dynamictrees.growthlogic.context.PositionalSpeciesContext;
import com.ferreusveritas.dynamictrees.util.CoordUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;

public class VariateHeightLogic
extends GrowthLogicKit {
    public static final ConfigurationProperty<Integer> LOWEST_BRANCH_VARIATION = ConfigurationProperty.integer((String)"lowest_branch_variation");

    public VariateHeightLogic(ResourceLocation registryName) {
        super(registryName);
    }

    protected GrowthLogicKitConfiguration createDefaultConfiguration() {
        return (GrowthLogicKitConfiguration)super.createDefaultConfiguration().with(HEIGHT_VARIATION, (Object)6);
    }

    protected void registerProperties() {
        this.register(new ConfigurationProperty[]{HEIGHT_VARIATION});
    }

    public static int getHashedVariation(LevelAccessor world, BlockPos pos, int heightVariation) {
        long day = world.m_8044_() / 24000L;
        int month = (int)day / 30;
        return CoordUtils.coordHashCode((BlockPos)pos.m_6630_(month), (int)2) % heightVariation;
    }

    public float getEnergy(GrowthLogicKitConfiguration configuration, PositionalSpeciesContext context) {
        Level world = context.level();
        BlockPos pos = context.pos();
        return super.getEnergy(configuration, context) * context.species().biomeSuitability(world, pos) + (float)VariateHeightLogic.getHashedVariation((LevelAccessor)world, pos, (Integer)configuration.get(HEIGHT_VARIATION));
    }

    public int getLowestBranchHeight(GrowthLogicKitConfiguration configuration, PositionalSpeciesContext context) {
        return super.getLowestBranchHeight(configuration, context) + VariateHeightLogic.getHashedVariation((LevelAccessor)context.level(), context.pos(), (Integer)configuration.get(HEIGHT_VARIATION));
    }
}

