/*
 * Decompiled with CFR 0.152.
 */
package maxhyper.dtbwg.init;

import com.ferreusveritas.dynamictrees.api.TreeHelper;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import maxhyper.dtbwg.blocks.DynamicWitchHazelBranch;
import maxhyper.dtbwg.init.DTBWGRegistries;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.potionstudios.biomeswevegone.world.level.block.BWGBlocks;
import net.potionstudios.biomeswevegone.world.level.block.plants.tree.branch.TreeBranchBlock;

@Mod.EventBusSubscriber(modid="dtbwg")
public class SideBranchPlaceEventHandler {
    static final Map<Supplier<TreeBranchBlock>, Supplier<DynamicWitchHazelBranch>> branches = ImmutableMap.builder().put((Object)BWGBlocks.WITCH_HAZEL_BRANCH, DTBWGRegistries.WITCH_HAZEL_BRANCH).build();

    @SubscribeEvent
    public static void onPlayerRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        BlockPos branchPos;
        BlockItem handBlockItem;
        Block block;
        Player player = event.getEntity();
        InteractionHand hand = event.getHand();
        ItemStack heldItem = player.m_21120_(hand);
        Item handItem = player.m_21120_(hand).m_41720_();
        Block bloomBranch = null;
        if (handItem instanceof BlockItem && (block = (handBlockItem = (BlockItem)handItem).m_40614_()) instanceof TreeBranchBlock) {
            TreeBranchBlock handBlock = (TreeBranchBlock)block;
            Supplier normalBranch = branches.keySet().stream().filter(i -> handBlock.equals(i.get())).findFirst().orElse(null);
            if (normalBranch != null) {
                bloomBranch = (Block)branches.get(normalBranch).get();
            }
        }
        if (bloomBranch == null) {
            return;
        }
        Level world = event.getLevel();
        BlockState state = world.m_8055_(branchPos = event.getPos());
        if (!TreeHelper.isBranch((BlockState)state) || TreeHelper.getRadius((BlockGetter)world, (BlockPos)branchPos) < 3) {
            return;
        }
        BlockPos pos = branchPos.m_121945_(Objects.requireNonNull(event.getFace()));
        if (!world.m_8055_(pos).m_247087_()) {
            return;
        }
        if (!player.m_7500_()) {
            heldItem.m_41774_(1);
        }
        world.m_5594_(null, pos, bloomBranch.getSoundType(state, (LevelReader)world, pos, (Entity)player).m_56777_(), SoundSource.BLOCKS, 1.0f, 0.8f);
        BlockPlaceContext context = new BlockPlaceContext(player, hand, heldItem, new BlockHitResult(player.m_20299_(1.0f), event.getFace(), branchPos, false));
        BlockState placeState = bloomBranch.m_5573_(context);
        if (placeState == null) {
            return;
        }
        world.m_7731_(pos, placeState, 3);
        event.setCancellationResult(InteractionResult.SUCCESS);
        event.setCanceled(true);
    }
}

