/*
 * Decompiled with CFR 0.152.
 */
package maxhyper.dtbwg.trees;

import com.ferreusveritas.dynamictrees.api.registry.TypedRegistry;
import com.ferreusveritas.dynamictrees.block.branch.BasicBranchBlock;
import com.ferreusveritas.dynamictrees.block.branch.BranchBlock;
import com.ferreusveritas.dynamictrees.block.leaves.DynamicLeavesBlock;
import com.ferreusveritas.dynamictrees.systems.GrowSignal;
import com.ferreusveritas.dynamictrees.tree.family.Family;
import com.ferreusveritas.dynamictrees.tree.species.Species;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;

public class DiagonalPalmFamily
extends Family {
    public static final TypedRegistry.EntryType<Family> TYPE = TypedRegistry.newType(DiagonalPalmFamily::new);

    public DiagonalPalmFamily(ResourceLocation name) {
        super(name);
    }

    protected BranchBlock createBranchBlock(ResourceLocation name) {
        BasicBranchBlock branch = new BasicBranchBlock(name, this.getProperties()){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public GrowSignal growIntoAir(Level world, BlockPos pos, GrowSignal signal, int fromRadius) {
                Species species = signal.getSpecies();
                DynamicLeavesBlock leaves = species.getLeavesBlock().orElse(null);
                if (leaves != null) {
                    if (fromRadius != this.getFamily().getPrimaryThickness()) return leaves.branchOut(world, pos, signal);
                    if (1.isNextToBranch((Level)world, (BlockPos)pos, (Direction)signal.dir.m_122424_())) {
                        signal.success = false;
                        return signal;
                    }
                    signal.success = leaves.growLeavesIfLocationIsSuitable((LevelAccessor)world, species.getLeavesProperties(), pos.m_7494_(), 0);
                    if (!signal.success) return signal;
                    return leaves.branchOut(world, pos, signal);
                }
                if (1.isNextToBranch((Level)world, (BlockPos)pos, (Direction)signal.dir.m_122424_())) {
                    signal.success = false;
                    return signal;
                }
                this.setRadius((LevelAccessor)world, pos, this.getFamily().getPrimaryThickness(), null);
                signal.radius = this.getFamily().getSecondaryThickness();
                signal.success = true;
                return signal;
            }
        };
        if (this.isFireProof()) {
            branch.setFireSpreadSpeed(0).setFlammability(0);
        }
        return branch;
    }
}

