/*
 * Decompiled with CFR 0.152.
 */
package maxhyper.dtbwg.trees;

import com.ferreusveritas.dynamictrees.api.registry.RegistryHandler;
import com.ferreusveritas.dynamictrees.api.registry.TypedRegistry;
import com.ferreusveritas.dynamictrees.block.DynamicSaplingBlock;
import com.ferreusveritas.dynamictrees.block.leaves.LeavesProperties;
import com.ferreusveritas.dynamictrees.item.Seed;
import com.ferreusveritas.dynamictrees.tree.family.Family;
import com.ferreusveritas.dynamictrees.tree.species.Species;
import com.ferreusveritas.dynamictrees.worldgen.GenerationContext;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;

public class LamentSpecies
extends Species {
    public static final TypedRegistry.EntryType<Species> TYPE = LamentSpecies.createDefaultType(LamentSpecies::new);
    private Species altSpecies = Species.NULL_SPECIES;

    public void setAltSpecies(Species altSpecies) {
        if (altSpecies != this) {
            this.altSpecies = altSpecies;
        }
    }

    public LamentSpecies(ResourceLocation name, Family family, LeavesProperties leavesProperties) {
        super(name, family, leavesProperties);
    }

    public boolean generate(GenerationContext context) {
        BlockPos.MutableBlockPos rootPos;
        LevelAccessor level = context.level();
        if (this.altSpecies.isAcceptableSoilForWorldgen(level, (BlockPos)(rootPos = context.rootPos()), level.m_8055_((BlockPos)rootPos))) {
            return this.altSpecies.generate(context);
        }
        return super.generate(context);
    }

    public boolean isAcceptableSoilForWorldgen(LevelAccessor level, BlockPos pos, BlockState soilBlockState) {
        return super.isAcceptableSoilForWorldgen(level, pos, soilBlockState) || this.altSpecies.isAcceptableSoilForWorldgen(level, pos, soilBlockState);
    }

    public boolean isAcceptableSoil(LevelReader level, BlockPos pos, BlockState soilBlockState) {
        return super.isAcceptableSoil(level, pos, soilBlockState) || this.altSpecies.isAcceptableSoil(level, pos, soilBlockState);
    }

    protected boolean transitionToTree(Level level, BlockPos pos, Family family) {
        if (this.altSpecies.isAcceptableSoil((LevelReader)level, pos.m_7495_(), level.m_8055_(pos.m_7495_()))) {
            return this.altSpecies.transitionToTree(level, pos);
        }
        return super.transitionToTree(level, pos, family);
    }

    public Species generateSeed() {
        return !this.shouldGenerateSeed() || this.seed != null ? this : this.setSeed((Supplier)RegistryHandler.addItem((ResourceLocation)this.getSeedName(), () -> new Seed(this){

            public boolean m_41475_() {
                return true;
            }
        }));
    }

    public boolean plantSapling(LevelAccessor level, BlockPos pos, boolean locationOverride) {
        FluidState fluidState = level.m_6425_(pos);
        FluidState fluidStateUp = level.m_6425_(pos.m_7494_());
        DynamicSaplingBlock sapling = this.getSapling().orElse(null);
        if (sapling != null && fluidState.m_76152_() == Fluids.f_76195_ && fluidStateUp.m_76152_() == Fluids.f_76191_) {
            return super.plantSapling(level, pos.m_7494_(), locationOverride);
        }
        return super.plantSapling(level, pos, locationOverride);
    }
}

