/*
 * Decompiled with CFR 0.152.
 */
package maxhyper.dtbwg.trees;

import com.ferreusveritas.dynamictrees.api.registry.TypedRegistry;
import com.ferreusveritas.dynamictrees.block.branch.BranchBlock;
import com.ferreusveritas.dynamictrees.tree.family.Family;
import com.ferreusveritas.dynamictrees.tree.species.Species;
import com.ferreusveritas.dynamictrees.util.BlockBounds;
import com.ferreusveritas.dynamictrees.util.BlockStates;
import com.ferreusveritas.dynamictrees.util.SimpleVoxmap;
import com.ferreusveritas.dynamictreesplus.block.mushroom.CapProperties;
import com.ferreusveritas.dynamictreesplus.block.mushroom.DynamicCapBlock;
import com.ferreusveritas.dynamictreesplus.block.mushroom.DynamicCapCenterBlock;
import com.ferreusveritas.dynamictreesplus.block.mushroom.MushroomBranchBlock;
import com.ferreusveritas.dynamictreesplus.systems.mushroomlogic.context.MushroomCapContext;
import com.ferreusveritas.dynamictreesplus.tree.HugeMushroomFamily;
import com.ferreusveritas.dynamictreesplus.tree.HugeMushroomSpecies;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import maxhyper.dtbwg.blocks.WartyCapProperties;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public class WartyMushroomFamily
extends HugeMushroomFamily {
    public static final TypedRegistry.EntryType<Family> TYPE = TypedRegistry.newType(WartyMushroomFamily::new);

    public WartyMushroomFamily(ResourceLocation name) {
        super(name);
    }

    protected BranchBlock createBranchBlock(ResourceLocation name) {
        MushroomBranchBlock branch = new MushroomBranchBlock(name, this.getProperties()){

            public void destroyMushroomCap(@NotNull Level level, @NotNull BlockPos cutPos, @NotNull Species species, @NotNull ItemStack tool, @NotNull List<BlockPos> endPoints, @NotNull Map<BlockPos, BlockState> destroyedCapBlocks, @NotNull List<BranchBlock.ItemStackPos> drops) {
                if (!(species instanceof HugeMushroomSpecies)) {
                    return;
                }
                HugeMushroomSpecies mushSpecies = (HugeMushroomSpecies)species;
                Family family = species.getFamily();
                if (!(family instanceof HugeMushroomFamily)) {
                    return;
                }
                HugeMushroomFamily family2 = (HugeMushroomFamily)family;
                if (level.f_46443_ || endPoints.isEmpty()) {
                    return;
                }
                BlockBounds bounds = this.getFamily().expandLeavesBlockBounds(new BlockBounds(endPoints));
                SimpleVoxmap capMap = new SimpleVoxmap(bounds);
                for (BlockPos endPos : endPoints) {
                    int age = DynamicCapCenterBlock.getCapAge((Level)level, (BlockPos)endPos.m_7494_());
                    if (age < 0) continue;
                    for (BlockPos findPos : mushSpecies.getMushroomShapeKit().getShapeCluster(new MushroomCapContext((LevelAccessor)level, endPos.m_7494_(), mushSpecies, Integer.valueOf(age)))) {
                        BlockState findState = level.m_8055_(findPos);
                        if (!family2.isCompatibleCap(mushSpecies, findState, level, findPos)) continue;
                        capMap.setVoxel(findPos.m_123341_(), findPos.m_123342_(), findPos.m_123343_(), (byte)1);
                    }
                    capMap.setVoxel(endPos, (byte)0);
                }
                ArrayList dropList = new ArrayList();
                for (SimpleVoxmap.Cell cell : capMap.getAllNonZeroCells()) {
                    BlockPos.MutableBlockPos pos = cell.getPos();
                    BlockState state = level.m_8055_((BlockPos)pos);
                    if (!family2.isCompatibleCap(mushSpecies, state, level, (BlockPos)pos)) continue;
                    dropList.clear();
                    CapProperties cap = this.getCapProperties(state);
                    Block shroomlightBlock = null;
                    if (cap instanceof WartyCapProperties) {
                        WartyCapProperties wartyCap = (WartyCapProperties)cap;
                        shroomlightBlock = wartyCap.getShroomlightBlock();
                    }
                    dropList.addAll(cap.getDrops(level, (BlockPos)pos, tool, species));
                    BlockPos imPos = pos.m_7949_();
                    BlockPos relPos = imPos.m_121996_((Vec3i)cutPos);
                    level.m_7731_(imPos, BlockStates.AIR, 3);
                    if (shroomlightBlock != null) {
                        BlockState upState = level.m_8055_(imPos.m_7494_());
                        BlockState downState = level.m_8055_(imPos.m_7495_());
                        if (upState.m_60713_(shroomlightBlock)) {
                            level.m_46961_(imPos.m_7494_(), true);
                        }
                        if (downState.m_60713_(shroomlightBlock)) {
                            level.m_46961_(imPos.m_7495_(), true);
                        }
                    }
                    destroyedCapBlocks.put(relPos, state);
                    dropList.forEach(i -> drops.add(new BranchBlock.ItemStackPos(i, relPos)));
                }
            }

            private CapProperties getCapProperties(BlockState state) {
                if (state.m_60734_() instanceof DynamicCapBlock) {
                    return Optional.of((DynamicCapBlock)state.m_60734_()).map(block -> block.getProperties(state)).orElse(CapProperties.NULL);
                }
                return state.m_60734_() instanceof DynamicCapCenterBlock ? Optional.of((DynamicCapCenterBlock)state.m_60734_()).map(block -> block.getProperties(state)).orElse(CapProperties.NULL) : CapProperties.NULL;
            }
        };
        if (this.isFireProof()) {
            branch.setFireSpreadSpeed(0).setFlammability(0);
        }
        return branch;
    }
}

