/*
 * Decompiled with CFR 0.152.
 */
package maxhyper.dtbwg.blocks;

import com.dtteam.dynamictrees.api.registry.TypedRegistry;
import com.dtteam.dynamictrees.block.fruit.Fruit;
import com.dtteam.dynamictrees.block.fruit.FruitBlock;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class EtherBulbsFruit
extends Fruit {
    public static final TypedRegistry.EntryType<Fruit> TYPE = TypedRegistry.newType(EtherBulbsFruit::new);

    public EtherBulbsFruit(ResourceLocation registryName) {
        super(registryName);
    }

    protected FruitBlock createBlock(BlockBehaviour.Properties properties) {
        return new FruitBlock(this, properties, this){

            public int getLightEmission(BlockState state, BlockGetter level, BlockPos pos) {
                return (Integer)state.getValue((Property)this.fruit.getAgeProperty()) >= 2 ? 15 : 4;
            }

            @OnlyIn(value=Dist.CLIENT)
            public void animateTick(BlockState stateIn, Level worldIn, BlockPos pos, Random rand) {
                VoxelShape shape = this.getShape(stateIn, (BlockGetter)worldIn, pos, CollisionContext.empty());
                Vec3 shapeCenter = shape.bounds().getCenter();
                double centerX = (double)pos.getX() + shapeCenter.x;
                double centerZ = (double)pos.getZ() + shapeCenter.z;
                for (int i = 0; i < 3; ++i) {
                    if (!rand.nextBoolean()) continue;
                    worldIn.addParticle((ParticleOptions)ParticleTypes.REVERSE_PORTAL, centerX + (double)(rand.nextFloat() / 5.0f), (double)pos.getY() + (0.5 - (double)rand.nextFloat()), centerZ + (double)(rand.nextFloat() / 5.0f), 0.0, 0.0, 0.0);
                }
            }
        };
    }
}

