/*
 * Decompiled with CFR 0.152.
 */
package maxhyper.dtbwg.blocks;

import com.dtteam.dynamictrees.api.registry.TypedRegistry;
import com.dtteam.dynamictrees.systems.poissondisc.Vec2i;
import com.dtteam.dynamictreesplus.block.mushroom.CapProperties;
import com.dtteam.dynamictreesplus.block.mushroom.DynamicCapBlock;
import com.dtteam.dynamictreesplus.block.mushroom.DynamicCapCenterBlock;
import com.dtteam.dynamictreesplus.systems.mushroomlogic.MushroomCapDisc;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;

public class WartyCapProperties
extends CapProperties {
    public static final TypedRegistry.EntryType<CapProperties> TYPE = TypedRegistry.newType(WartyCapProperties::new);
    protected Block shroomlightBlock = Blocks.SHROOMLIGHT;
    protected float extraWartChance = 0.5f;
    protected float shroomlightUpChance = 0.02f;
    protected float shroomlightDownChance = 0.2f;
    protected boolean shroomlightRequireSupport = true;

    public WartyCapProperties(ResourceLocation registryName) {
        super(registryName);
    }

    protected String getBlockRegistryNameSuffix() {
        return "_wart";
    }

    protected String getCenterBlockRegistryNameSuffix() {
        return "_wart_center";
    }

    public void setShroomlightBlock(Block shroomlightBlock) {
        this.shroomlightBlock = shroomlightBlock;
    }

    public Block getShroomlightBlock() {
        return this.shroomlightBlock;
    }

    public void setShroomlightUpChance(float shroomlightUpChance) {
        this.shroomlightUpChance = shroomlightUpChance;
    }

    public void setShroomlightDownChance(float shroomlightDownChance) {
        this.shroomlightDownChance = shroomlightDownChance;
    }

    public void setShroomlightRequireSupport(boolean shroomlightRequireSupport) {
        this.shroomlightRequireSupport = shroomlightRequireSupport;
    }

    public BlockBehaviour.Properties getDefaultBlockProperties(MapColor mapColor) {
        return BlockBehaviour.Properties.of().mapColor(MapColor.GRASS).strength(1.0f).sound(SoundType.WART_BLOCK);
    }

    protected DynamicCapBlock createDynamicCap(BlockBehaviour.Properties properties) {
        return new DynamicCapBlock(this, properties){

            public void tick(BlockState pState, ServerLevel level, BlockPos pos, RandomSource pRandom) {
                if (level.getBlockState(pos).getBlock() == this) {
                    int dist = (Integer)pState.getValue((Property)DISTANCE);
                    boolean supportFound = false;
                    for (BlockPos offPos : BlockPos.withinManhattan((BlockPos)pos, (int)1, (int)1, (int)1)) {
                        BlockState offsetState;
                        if (offPos == pos || (!(offsetState = level.getBlockState(offPos)).hasProperty((Property)DISTANCE) || (Integer)offsetState.getValue((Property)DISTANCE) != dist - 1) && (dist != 1 || offsetState.getBlock() != this.properties.getDynamicCapCenterBlock().orElse(null))) continue;
                        supportFound = true;
                        break;
                    }
                    if (!supportFound) {
                        level.destroyBlock(pos, true);
                        BlockState upState = level.getBlockState(pos.above());
                        BlockState downState = level.getBlockState(pos.below());
                        if (upState.is(WartyCapProperties.this.shroomlightBlock)) {
                            level.destroyBlock(pos.above(), true);
                        }
                        if (downState.is(WartyCapProperties.this.shroomlightBlock)) {
                            level.destroyBlock(pos.below(), true);
                        }
                        this.updateNeighborsSurround((Level)level, pos, DynamicCapBlock.class);
                    } else {
                        super.tick(pState, level, pos, pRandom);
                    }
                }
            }
        };
    }

    protected DynamicCapCenterBlock createDynamicCapCenter(BlockBehaviour.Properties properties) {
        return new DynamicCapCenterBlock(this, properties){

            public List<BlockPos> getRing(LevelAccessor level, BlockPos pos, int radius) {
                List ring = MushroomCapDisc.getPrecomputedRing((int)radius);
                LinkedList<BlockPos> positions = new LinkedList<BlockPos>();
                for (Vec2i vec : ring) {
                    BlockPos ringPos = new BlockPos(pos.getX() + vec.x, pos.getY(), pos.getZ() + vec.z);
                    if (!this.properties.isPartOfCap(level.getBlockState(ringPos))) continue;
                    positions.add(ringPos);
                    if (this.properties.isPartOfCap(level.getBlockState(ringPos.above()))) {
                        positions.add(ringPos.above());
                    }
                    if (!this.properties.isPartOfCap(level.getBlockState(ringPos.below()))) continue;
                    positions.add(ringPos.below());
                }
                return positions;
            }

            public void clearRing(LevelAccessor level, BlockPos pos, int radius) {
                List ring = MushroomCapDisc.getPrecomputedRing((int)radius);
                for (Vec2i vec : ring) {
                    BlockPos ringPos = new BlockPos(pos.getX() + vec.x, pos.getY(), pos.getZ() + vec.z);
                    if (!this.properties.isPartOfCap(level.getBlockState(ringPos))) continue;
                    BlockState upState = level.getBlockState(ringPos.above());
                    BlockState downState = level.getBlockState(ringPos.below());
                    if (this.properties.isPartOfCap(upState) || upState.is(WartyCapProperties.this.shroomlightBlock)) {
                        level.setBlock(ringPos.above(), Blocks.AIR.defaultBlockState(), 2);
                    }
                    if (this.properties.isPartOfCap(downState) || downState.is(WartyCapProperties.this.shroomlightBlock)) {
                        level.setBlock(ringPos.below(), Blocks.AIR.defaultBlockState(), 2);
                    }
                    level.setBlock(ringPos, Blocks.AIR.defaultBlockState(), 2);
                }
            }

            public boolean placeRing(LevelAccessor level, BlockPos pos, int radius, int step, boolean yMoved, boolean negFactor) {
                List ring = MushroomCapDisc.getPrecomputedRing((int)radius);
                int placed = 0;
                int notPlaced = 0;
                int age = 0;
                for (int i = 0; i < 8; ++i) {
                    BlockPos searchPos = pos.above((negFactor ? -1 : 1) * i);
                    BlockState searchState = level.getBlockState(searchPos);
                    if (!searchState.hasProperty((Property)AGE)) continue;
                    age = (Integer)searchState.getValue((Property)AGE);
                    break;
                }
                boolean lastRing = step == age;
                for (Vec2i vec : ring) {
                    BlockPos ringPos = new BlockPos(pos.getX() + vec.x, pos.getY(), pos.getZ() + vec.z);
                    if (2.canCapReplace((BlockState)level.getBlockState(ringPos))) {
                        BlockState placeCapState = this.getStateForAge(this.properties, step, new Vec2i(-vec.x, -vec.z), yMoved, negFactor, this.properties.isPartOfCap(level.getBlockState(ringPos.above())), lastRing);
                        level.setBlock(ringPos, placeCapState, 2);
                        if (step <= 8 && step > 1) {
                            this.placeExtraWart(level, ringPos.above(), placeCapState, true, WartyCapProperties.this.shroomlightUpChance);
                            this.placeExtraWart(level, ringPos.below(), placeCapState, false, WartyCapProperties.this.shroomlightDownChance);
                        }
                        ++placed;
                        continue;
                    }
                    ++notPlaced;
                }
                return placed >= notPlaced;
            }

            private void placeExtraWart(LevelAccessor level, BlockPos ringPos, BlockState placeCapState, boolean checkAround, float shroomlightChance) {
                if (level.getRandom().nextFloat() < WartyCapProperties.this.extraWartChance && 2.canCapReplace((BlockState)level.getBlockState(ringPos))) {
                    boolean canPlace;
                    if (!WartyCapProperties.this.shroomlightRequireSupport && level.getRandom().nextFloat() < shroomlightChance) {
                        level.setBlock(ringPos, WartyCapProperties.this.shroomlightBlock.defaultBlockState(), 2);
                        return;
                    }
                    boolean bl = canPlace = !checkAround;
                    if (checkAround) {
                        for (Direction dir : Direction.Plane.HORIZONTAL) {
                            if (!this.properties.isPartOfCap(level.getBlockState(ringPos.offset(dir.getNormal())))) continue;
                            canPlace = true;
                            break;
                        }
                    }
                    if (canPlace) {
                        BlockState place = placeCapState;
                        if (level.getRandom().nextFloat() < shroomlightChance) {
                            place = WartyCapProperties.this.shroomlightBlock.defaultBlockState();
                        }
                        level.setBlock(ringPos, place, 2);
                    }
                }
            }

            @Nonnull
            private BlockState getStateForAge(CapProperties properties, int age, Vec2i centerDirection, boolean yMoved, boolean negativeFactor, boolean topIsCap, boolean lastRing) {
                boolean[] dirs = new boolean[]{lastRing, !topIsCap, true, true, true, true};
                if (yMoved || age == 1) {
                    for (Direction dir : Direction.Plane.HORIZONTAL) {
                        float dot = dir.getNormal().getX() * centerDirection.x + dir.getNormal().getZ() * centerDirection.z;
                        if (!(dot >= 0.0f)) continue;
                        dirs[negativeFactor ? dir.getOpposite().ordinal() : dir.ordinal()] = false;
                    }
                }
                return properties.getDynamicCapState(age, dirs);
            }
        };
    }
}

