/*
 * Decompiled with CFR 0.152.
 */
package maxhyper.dtbwg.blocks;

import com.dtteam.dynamictrees.api.registry.TypedRegistry;
import com.dtteam.dynamictrees.api.voxmap.SimpleVoxmap;
import com.dtteam.dynamictrees.systems.poissondisc.Vec2i;
import com.dtteam.dynamictreesplus.block.mushroom.CapProperties;
import com.dtteam.dynamictreesplus.block.mushroom.DynamicCapCenterBlock;
import com.dtteam.dynamictreesplus.systems.mushroomlogic.MushroomCapDisc;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class WeepingMilkcapCapProperties
extends CapProperties {
    public static final TypedRegistry.EntryType<CapProperties> TYPE = TypedRegistry.newType(WeepingMilkcapCapProperties::new);
    public static final SimpleVoxmap PATTERN_A = new SimpleVoxmap(9, 1, 9, new byte[]{0, 0, 0, 1, 0, 1, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0, 0, 0}).setCenter(new BlockPos(4, 0, 4));
    public static final SimpleVoxmap PATTERN_B = new SimpleVoxmap(5, 1, 5, new byte[]{0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0}).setCenter(new BlockPos(2, 0, 2));

    public WeepingMilkcapCapProperties(ResourceLocation registryName) {
        super(registryName);
    }

    protected DynamicCapCenterBlock createDynamicCapCenter(BlockBehaviour.Properties properties) {
        return new DynamicCapCenterBlock(this, this, properties){

            public boolean placeRing(LevelAccessor level, BlockPos pos, int radius, int step, boolean yMoved, boolean negFactor) {
                List ring = MushroomCapDisc.getPrecomputedRing((int)radius);
                int placed = 0;
                int notPlaced = 0;
                int age = 0;
                for (int i = 0; i < 8; ++i) {
                    BlockPos searchPos = pos.above((negFactor ? -1 : 1) * i);
                    BlockState searchState = level.getBlockState(searchPos);
                    if (!searchState.hasProperty((Property)AGE)) continue;
                    age = (Integer)searchState.getValue((Property)AGE);
                    break;
                }
                for (Vec2i vec : ring) {
                    if ((age == 4 || age == 3) && PATTERN_A.getVoxel(vec.x, 0, vec.z) == 1 || age == 2 && PATTERN_B.getVoxel(vec.x, 0, vec.z) == 1) continue;
                    BlockPos ringPos = new BlockPos(pos.getX() + vec.x, pos.getY(), pos.getZ() + vec.z);
                    if (1.canCapReplace((BlockState)level.getBlockState(ringPos))) {
                        BlockState placeCapState = this.getStateForAge(this.properties, step, new Vec2i(-vec.x, -vec.z), yMoved, negFactor, this.properties.isPartOfCap(level.getBlockState(ringPos.above())));
                        level.setBlock(ringPos, placeCapState, 2);
                        ++placed;
                        continue;
                    }
                    ++notPlaced;
                }
                return placed >= notPlaced;
            }

            @Nonnull
            private BlockState getStateForAge(CapProperties properties, int age, Vec2i centerDirection, boolean yMoved, boolean negativeFactor, boolean topIsCap) {
                boolean[] dirs = new boolean[]{false, !topIsCap, false, false, false, false};
                if (yMoved || age == 1) {
                    for (Direction dir : Direction.Plane.HORIZONTAL) {
                        float dot = dir.getNormal().getX() * centerDirection.x + dir.getNormal().getZ() * centerDirection.z;
                        if (!(dot >= 0.0f)) continue;
                        dirs[negativeFactor ? dir.ordinal() : dir.getOpposite().ordinal()] = true;
                    }
                }
                return properties.getDynamicCapState(age, dirs);
            }
        };
    }

    static {
        PATTERN_A.setYTouched(0);
        PATTERN_B.setYTouched(0);
    }
}

