/*
 * Decompiled with CFR 0.152.
 */
package maxhyper.dtbwg.genfeatures;

import com.dtteam.dynamictrees.api.configuration.ConfigurationProperty;
import com.dtteam.dynamictrees.api.network.MapSignal;
import com.dtteam.dynamictrees.api.network.NodeInspector;
import com.dtteam.dynamictrees.block.branch.BranchBlock;
import com.dtteam.dynamictrees.systems.genfeature.GenFeature;
import com.dtteam.dynamictrees.systems.genfeature.GenFeatureConfiguration;
import com.dtteam.dynamictrees.systems.genfeature.context.PostGenerationContext;
import com.dtteam.dynamictrees.systems.genfeature.context.PostGrowContext;
import com.dtteam.dynamictrees.tree.TreeHelper;
import com.dtteam.dynamictrees.tree.family.Family;
import com.dtteam.dynamictrees.tree.species.Species;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.random.SimpleWeightedRandomList;
import net.minecraft.util.random.WeightedEntry;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import org.apache.logging.log4j.LogManager;

public class AlternativeBranchGenFeature
extends GenFeature {
    public static final ConfigurationProperty<Float> WORLDGEN_PLACE_CHANCE = ConfigurationProperty.floatProperty((String)"worldgen_place_chance");
    public static final ConfigurationProperty<Block> ALT_BRANCH_BLOCK = ConfigurationProperty.block((String)"alternative_branch_block");
    public static final ConfigurationProperty<Integer> MIN_RADIUS = ConfigurationProperty.integer((String)"minimum_radius");

    public AlternativeBranchGenFeature(ResourceLocation registryName) {
        super(registryName);
    }

    public boolean shouldApply(Species species, GenFeatureConfiguration configuration) {
        Block branch = (Block)configuration.get(ALT_BRANCH_BLOCK);
        if (TreeHelper.isBranch((Block)branch) && species.getFamily().isValidBranchBlock((BranchBlock)branch)) {
            return true;
        }
        LogManager.getLogger().warn("Failed to find branch block for the alternative branch feature on species {}", (Object)species);
        return false;
    }

    public GenFeatureConfiguration createDefaultConfiguration() {
        return (GenFeatureConfiguration)((GenFeatureConfiguration)((GenFeatureConfiguration)((GenFeatureConfiguration)((GenFeatureConfiguration)super.createDefaultConfiguration().with(ALT_BRANCH_BLOCK, (Object)Blocks.AIR)).with(PLACE_CHANCE, (Object)Float.valueOf(0.04f))).with(WORLDGEN_PLACE_CHANCE, (Object)Float.valueOf(0.2f))).with(MIN_RADIUS, (Object)4)).with(FRUITING_RADIUS, (Object)6);
    }

    protected void registerProperties() {
        this.register(new ConfigurationProperty[]{ALT_BRANCH_BLOCK, PLACE_CHANCE, WORLDGEN_PLACE_CHANCE, MIN_RADIUS, FRUITING_RADIUS});
    }

    protected boolean postGenerate(GenFeatureConfiguration configuration, PostGenerationContext context) {
        BlockPos rootPos;
        LevelAccessor level = context.level();
        BlockState blockState = level.getBlockState((rootPos = context.pos()).above());
        BranchBlock branch = TreeHelper.getBranch((BlockState)blockState);
        if (branch != null && branch.getRadius(blockState) >= (Integer)configuration.get(FRUITING_RADIUS)) {
            this.placeAltBranches(true, configuration, level, rootPos, context.species().getFamily());
        }
        return true;
    }

    protected boolean postGrow(GenFeatureConfiguration configuration, PostGrowContext context) {
        BlockPos rootPos;
        if (context.fertility() == 0) {
            return false;
        }
        LevelAccessor level = context.level();
        BlockState blockState = level.getBlockState((rootPos = context.pos()).above());
        BranchBlock branch = TreeHelper.getBranch((BlockState)blockState);
        if (branch != null && branch.getRadius(blockState) >= (Integer)configuration.get(FRUITING_RADIUS) && context.natural() && level.getRandom().nextFloat() < ((Float)configuration.get(PLACE_CHANCE)).floatValue()) {
            this.placeAltBranches(false, configuration, level, rootPos, context.species().getFamily());
        }
        return true;
    }

    private void placeAltBranches(boolean isWorldgen, GenFeatureConfiguration configuration, LevelAccessor world, BlockPos rootPos, Family family) {
        SimpleWeightedRandomList.Builder listBuilder = new SimpleWeightedRandomList.Builder();
        FindValidBranchesNode altBranchPlacer = new FindValidBranchesNode((SimpleWeightedRandomList.Builder<BlockPos>)listBuilder, (Integer)configuration.get(MIN_RADIUS), family);
        TreeHelper.startAnalysisFromRoot((LevelAccessor)world, (BlockPos)rootPos, (MapSignal)new MapSignal(new NodeInspector[]{altBranchPlacer}));
        SimpleWeightedRandomList validSpots = listBuilder.build();
        if (!validSpots.isEmpty()) {
            if (isWorldgen) {
                for (BlockPos listPos : validSpots.unwrap().stream().map(WeightedEntry.Wrapper::data).collect(Collectors.toList())) {
                    if (!(world.getRandom().nextFloat() < ((Float)configuration.get(WORLDGEN_PLACE_CHANCE)).floatValue())) continue;
                    this.placeBranch(configuration, world, listPos);
                }
            } else {
                WeightedEntry.Wrapper posWrapper = validSpots.getRandom(world.getRandom()).orElse(null);
                if (posWrapper == null) {
                    return;
                }
                this.placeBranch(configuration, world, (BlockPos)posWrapper.data());
            }
        }
    }

    private void placeBranch(GenFeatureConfiguration configuration, LevelAccessor world, BlockPos pos) {
        BranchBlock branchToPlace = (BranchBlock)configuration.get(ALT_BRANCH_BLOCK);
        int radius = TreeHelper.getRadius((BlockGetter)world, (BlockPos)pos);
        branchToPlace.setRadius(world, pos, radius, null);
    }

    public static class FindValidBranchesNode
    implements NodeInspector {
        private final SimpleWeightedRandomList.Builder<BlockPos> validSpots;
        private final int minRadius;
        private final Family family;

        public FindValidBranchesNode(SimpleWeightedRandomList.Builder<BlockPos> validSpots, int minRadius, Family family) {
            this.validSpots = validSpots;
            this.minRadius = minRadius;
            this.family = family;
        }

        public boolean run(BlockState state, LevelAccessor level, BlockPos pos, Direction fromDir) {
            boolean valid;
            int radius = TreeHelper.getRadius((BlockGetter)level, (BlockPos)pos);
            boolean bl = valid = radius >= this.minRadius && state.getBlock() == this.family.getValidBranchBlock(0);
            if (valid) {
                this.validSpots.add((Object)pos, radius);
            }
            return valid;
        }

        public boolean returnRun(BlockState state, LevelAccessor level, BlockPos pos, Direction fromDir) {
            return false;
        }
    }
}

