/*
 * Decompiled with CFR 0.152.
 */
package maxhyper.dtbwg.genfeatures;

import com.dtteam.dynamictrees.api.configuration.ConfigurationProperty;
import com.dtteam.dynamictrees.systems.genfeature.GenFeature;
import com.dtteam.dynamictrees.systems.genfeature.GenFeatureConfiguration;
import com.dtteam.dynamictrees.systems.genfeature.context.PostGenerationContext;
import com.dtteam.dynamictrees.systems.genfeature.context.PostGrowContext;
import com.dtteam.dynamictrees.tree.TreeHelper;
import com.dtteam.dynamictrees.tree.family.Family;
import com.dtteam.dynamictrees.tree.species.Species;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;

public class ExtraBottomFlareGenFeature
extends GenFeature {
    public static final ConfigurationProperty<Integer> MIN_RADIUS = ConfigurationProperty.integer((String)"min_radius");
    public static final ConfigurationProperty<Integer> SECONDARY_MIN_RADIUS = ConfigurationProperty.integer((String)"secondary_min_radius");

    public ExtraBottomFlareGenFeature(ResourceLocation registryName) {
        super(registryName);
    }

    protected void registerProperties() {
        this.register(new ConfigurationProperty[]{MIN_RADIUS, SECONDARY_MIN_RADIUS});
    }

    public GenFeatureConfiguration createDefaultConfiguration() {
        return (GenFeatureConfiguration)((GenFeatureConfiguration)super.createDefaultConfiguration().with(MIN_RADIUS, (Object)6)).with(SECONDARY_MIN_RADIUS, (Object)8);
    }

    protected boolean postGenerate(GenFeatureConfiguration configuration, PostGenerationContext context) {
        this.flareBottom(configuration, context.level(), context.pos(), context.species());
        return true;
    }

    protected boolean postGrow(GenFeatureConfiguration configuration, PostGrowContext context) {
        if (context.fertility() > 0) {
            this.flareBottom(configuration, context.level(), context.pos(), context.species());
            return true;
        }
        return false;
    }

    public void flareBottom(GenFeatureConfiguration configuration, LevelAccessor level, BlockPos rootPos, Species species) {
        Family family = species.getFamily();
        int radius4 = TreeHelper.getRadius((BlockGetter)level, (BlockPos)rootPos.above(4));
        if (radius4 > (Integer)configuration.get(SECONDARY_MIN_RADIUS)) {
            family.getBranch().ifPresent(branch -> {
                branch.setRadius(level, rootPos.above(3), radius4 + 1, Direction.UP);
                branch.setRadius(level, rootPos.above(2), radius4 + 3, Direction.UP);
                branch.setRadius(level, rootPos.above(1), radius4 + 6, Direction.UP);
            });
        } else {
            int radius3 = TreeHelper.getRadius((BlockGetter)level, (BlockPos)rootPos.above(3));
            if (radius3 > (Integer)configuration.get(MIN_RADIUS)) {
                family.getBranch().ifPresent(branch -> {
                    branch.setRadius(level, rootPos.above(2), radius3 + 1, Direction.UP);
                    branch.setRadius(level, rootPos.above(1), radius3 + 2, Direction.UP);
                });
            }
        }
    }
}

