/*
 * Decompiled with CFR 0.152.
 */
package maxhyper.dtbwg.init;

import com.dtteam.dynamictrees.api.cell.CellKit;
import com.dtteam.dynamictrees.api.registry.Registry;
import com.dtteam.dynamictrees.api.registry.RegistryEntry;
import com.dtteam.dynamictrees.api.registry.RegistryHandler;
import com.dtteam.dynamictrees.api.worldgen.FeatureCanceller;
import com.dtteam.dynamictrees.block.CommonVoxelShapes;
import com.dtteam.dynamictrees.event.RegistryEvent;
import com.dtteam.dynamictrees.event.TypeRegistryEvent;
import com.dtteam.dynamictrees.systems.BranchConnectables;
import com.dtteam.dynamictrees.systems.genfeature.GenFeature;
import com.dtteam.dynamictrees.systems.growthlogic.GrowthLogicKit;
import com.dtteam.dynamictrees.tree.family.Family;
import com.dtteam.dynamictrees.tree.species.Species;
import com.dtteam.dynamictreesplus.block.mushroom.CapProperties;
import com.dtteam.dynamictreesplus.systems.mushroomlogic.shapekits.MushroomShapeKit;
import dev.corgitaco.ohthetreesyoullgrow.world.level.levelgen.feature.configurations.TreeFromStructureNBTConfig;
import java.util.function.Supplier;
import maxhyper.dtbwg.DynamicTreesBWG;
import maxhyper.dtbwg.blocks.DynamicWitchHazelBranch;
import maxhyper.dtbwg.blocks.WartyCapProperties;
import maxhyper.dtbwg.blocks.WeepingMilkcapCapProperties;
import maxhyper.dtbwg.cancellers.BWGTreeFeatureCanceller;
import maxhyper.dtbwg.cells.DTBWGCellKits;
import maxhyper.dtbwg.genfeatures.DTBWGGenFeatures;
import maxhyper.dtbwg.growthlogic.DTBWGGrowthLogicKits;
import maxhyper.dtbwg.mushroomshape.BWGMushroomShapeKits;
import maxhyper.dtbwg.trees.DiagonalPalmFamily;
import maxhyper.dtbwg.trees.GenOnExtraSoilSpecies;
import maxhyper.dtbwg.trees.GenUnderwaterSpecies;
import maxhyper.dtbwg.trees.ImbuedLogFamily;
import maxhyper.dtbwg.trees.LamentSpecies;
import maxhyper.dtbwg.trees.MangroveSpecies;
import maxhyper.dtbwg.trees.PoplarSpecies;
import maxhyper.dtbwg.trees.TwigletSpecies;
import maxhyper.dtbwg.trees.WartyMushroomFamily;
import maxhyper.dtbwg.trees.WoodyHugeMushroomSpecies;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.potionstudios.biomeswevegone.world.level.block.BWGBlocks;

@EventBusSubscriber
public class DTBWGRegistries {
    public static final VoxelShape MUSHROOM_STEM_LONG = DTBWGRegistries.box(7.0, 0.0, 7.0, 9.0, 10.0, 9.0);
    public static final VoxelShape TALL_MUSHROOM_CAP_FLAT = DTBWGRegistries.box(5.0, 7.0, 5.0, 11.0, 10.0, 11.0);
    public static final VoxelShape MUSHROOM_CAP_SHORT_ROUND = DTBWGRegistries.box(5.0, 3.0, 5.0, 11.0, 7.0, 11.0);
    public static final VoxelShape TALL_FLAT_MUSHROOM = Shapes.or((VoxelShape)MUSHROOM_STEM_LONG, (VoxelShape)TALL_MUSHROOM_CAP_FLAT);
    public static final VoxelShape SHORT_ROUND_MUSHROOM = Shapes.or((VoxelShape)CommonVoxelShapes.SAPLING_TRUNK, (VoxelShape)MUSHROOM_CAP_SHORT_ROUND);
    public static Supplier<DynamicWitchHazelBranch> WITCH_HAZEL_BRANCH = RegistryHandler.addBlock((ResourceLocation)DynamicTreesBWG.location("witch_hazel_side_branch"), () -> new DynamicWitchHazelBranch((Block)BWGBlocks.WITCH_HAZEL_BRANCH.get()));
    public static Supplier<DynamicWitchHazelBranch> SHELF_FUNGI = RegistryHandler.addBlock((ResourceLocation)DynamicTreesBWG.location("shelf_fungi"), () -> new DynamicWitchHazelBranch((Block)BWGBlocks.SHELF_FUNGI.get()));
    public static final FeatureCanceller biomeswevegone_TREE_CANCELLER = new BWGTreeFeatureCanceller<TreeFromStructureNBTConfig>(DynamicTreesBWG.location("tree"), TreeFromStructureNBTConfig.class);

    private static VoxelShape box(double p_49797_, double p_49798_, double p_49799_, double p_49800_, double p_49801_, double p_49802_) {
        return Shapes.box((double)(p_49797_ / 16.0), (double)(p_49798_ / 16.0), (double)(p_49799_ / 16.0), (double)(p_49800_ / 16.0), (double)(p_49801_ / 16.0), (double)(p_49802_ / 16.0));
    }

    public static void setup() {
        CommonVoxelShapes.SHAPES.put(DynamicTreesBWG.location("tall_flat_mushroom").toString(), TALL_FLAT_MUSHROOM);
        CommonVoxelShapes.SHAPES.put(DynamicTreesBWG.location("short_round_mushroom").toString(), SHORT_ROUND_MUSHROOM);
    }

    public static void setupBlocks() {
        DTBWGRegistries.setupConnectables();
    }

    private static void setupConnectables() {
        for (Block block : new Block[]{(Block)WITCH_HAZEL_BRANCH.get()}) {
            BranchConnectables.makeBlockConnectable((Block)block, (state, world, pos, side) -> {
                if (state.hasProperty((Property)HorizontalDirectionalBlock.FACING)) {
                    return state.getValue((Property)HorizontalDirectionalBlock.FACING) == side ? 1 : 0;
                }
                return 0;
            });
        }
    }

    @SubscribeEvent
    public static void registerGenFeature(RegistryEvent<GenFeature> event) {
        if (event.isEntryOfType(GenFeature.class)) {
            DTBWGGenFeatures.register((Registry<GenFeature>)event.getRegistry());
        }
    }

    @SubscribeEvent
    public static void registerCells(RegistryEvent<CellKit> event) {
        if (event.isEntryOfType(CellKit.class)) {
            DTBWGCellKits.register((Registry<CellKit>)event.getRegistry());
        }
    }

    @SubscribeEvent
    public static void registerGrowthLogic(RegistryEvent<GrowthLogicKit> event) {
        if (event.isEntryOfType(GrowthLogicKit.class)) {
            DTBWGGrowthLogicKits.register((Registry<GrowthLogicKit>)event.getRegistry());
        }
    }

    @SubscribeEvent
    public static void registerSpeciesTypes(TypeRegistryEvent<Species> event) {
        event.registerType(DynamicTreesBWG.location("poplar"), PoplarSpecies.TYPE);
        event.registerType(DynamicTreesBWG.location("twiglet"), TwigletSpecies.TYPE);
        event.registerType(DynamicTreesBWG.location("generates_underwater"), GenUnderwaterSpecies.TYPE);
        event.registerType(DynamicTreesBWG.location("generates_on_extra_soil"), GenOnExtraSoilSpecies.TYPE);
        event.registerType(DynamicTreesBWG.location("mangrove"), MangroveSpecies.TYPE);
        event.registerType(DynamicTreesBWG.location("lament"), LamentSpecies.TYPE);
        event.registerType(DynamicTreesBWG.location("woody_mushroom"), WoodyHugeMushroomSpecies.TYPE);
    }

    @SubscribeEvent
    public static void registerFamilyTypes(TypeRegistryEvent<Family> event) {
        event.registerType(DynamicTreesBWG.location("imbued_log"), ImbuedLogFamily.TYPE);
        event.registerType(DynamicTreesBWG.location("diagonal_palm"), DiagonalPalmFamily.TYPE);
        event.registerType(DynamicTreesBWG.location("warty_mushroom"), WartyMushroomFamily.TYPE);
    }

    @SubscribeEvent
    public static void registerCapPropertiesTypes(TypeRegistryEvent<CapProperties> event) {
        event.registerType(DynamicTreesBWG.location("warty_cap"), WartyCapProperties.TYPE);
        event.registerType(DynamicTreesBWG.location("weeping_milkcap_cap"), WeepingMilkcapCapProperties.TYPE);
    }

    @SubscribeEvent
    public static void registerMushroomShape(RegistryEvent<MushroomShapeKit> event) {
        if (event.isEntryOfType(MushroomShapeKit.class)) {
            BWGMushroomShapeKits.register((Registry<MushroomShapeKit>)event.getRegistry());
        }
    }

    @SubscribeEvent
    public static void registerFeatureCanceller(RegistryEvent<FeatureCanceller> event) {
        if (event.isEntryOfType(FeatureCanceller.class)) {
            event.getRegistry().registerAll((RegistryEntry[])new FeatureCanceller[]{biomeswevegone_TREE_CANCELLER});
        }
    }
}

