/*
 * Decompiled with CFR 0.152.
 */
package maxhyper.dtbwg.trees;

import com.dtteam.dynamictrees.api.registry.TypedRegistry;
import com.dtteam.dynamictrees.block.branch.BasicBranchBlock;
import com.dtteam.dynamictrees.block.branch.BranchBlock;
import com.dtteam.dynamictrees.block.branch.ThickBranchBlock;
import com.dtteam.dynamictrees.block.leaves.DynamicLeavesBlock;
import com.dtteam.dynamictrees.systems.GrowSignal;
import com.dtteam.dynamictrees.tree.family.Family;
import com.dtteam.dynamictrees.tree.species.Species;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import org.jetbrains.annotations.NotNull;

public class DiagonalPalmFamily
extends Family {
    public static final TypedRegistry.EntryType<Family> TYPE = TypedRegistry.newType(DiagonalPalmFamily::new);

    public DiagonalPalmFamily(ResourceLocation name) {
        super(name);
    }

    protected BranchBlock createBranchBlock(ResourceLocation name) {
        Object branch;
        Object object = branch = this.isThick() ? new ThickBranchBlock(this, name, this.getProperties()){

            @NotNull
            public GrowSignal growIntoAir(Level world, BlockPos pos, GrowSignal signal, int fromRadius) {
                return DiagonalPalmFamily.growIntoAir(world, pos, signal, fromRadius, (BranchBlock)this);
            }
        } : new BasicBranchBlock(this, name, this.getProperties()){

            @NotNull
            public GrowSignal growIntoAir(Level world, BlockPos pos, GrowSignal signal, int fromRadius) {
                return DiagonalPalmFamily.growIntoAir(world, pos, signal, fromRadius, (BranchBlock)this);
            }
        };
        if (this.isFireProof()) {
            branch.setFireSpreadSpeed(0).setFlammability(0);
        }
        return branch;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static GrowSignal growIntoAir(Level world, BlockPos pos, GrowSignal signal, int fromRadius, BranchBlock branchBlock) {
        Species species = signal.getSpecies();
        DynamicLeavesBlock leaves = species.getLeavesBlock().orElse(null);
        if (leaves != null) {
            if (fromRadius != branchBlock.getFamily().getPrimaryThickness()) return leaves.branchOut(world, pos, signal);
            if (BranchBlock.isNextToBranch((Level)world, (BlockPos)pos, (Direction)signal.dir.getOpposite())) {
                signal.success = false;
                return signal;
            }
            boolean bl = signal.success = leaves.growLeavesIfLocationIsSuitable((LevelAccessor)world, species.getLeavesProperties(), pos.above(), Integer.valueOf(0)) != 0;
            if (!signal.success) return signal;
            return leaves.branchOut(world, pos, signal);
        }
        if (BranchBlock.isNextToBranch((Level)world, (BlockPos)pos, (Direction)signal.dir.getOpposite())) {
            signal.success = false;
            return signal;
        }
        branchBlock.setRadius((LevelAccessor)world, pos, branchBlock.getFamily().getPrimaryThickness(), null);
        signal.radius = branchBlock.getFamily().getSecondaryThickness();
        signal.success = true;
        return signal;
    }
}

