/*
 * Decompiled with CFR 0.152.
 */
package maxhyper.dtbwg.trees;

import com.dtteam.dynamictrees.api.registry.RegistryHandler;
import com.dtteam.dynamictrees.api.registry.TypedRegistry;
import com.dtteam.dynamictrees.block.leaves.LeavesProperties;
import com.dtteam.dynamictrees.block.sapling.DynamicSaplingBlock;
import com.dtteam.dynamictrees.item.Seed;
import com.dtteam.dynamictrees.tree.family.Family;
import com.dtteam.dynamictrees.tree.species.Species;
import com.dtteam.dynamictrees.worldgen.DynamicTreeGenerationContext;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;

public class LamentSpecies
extends Species {
    public static final TypedRegistry.EntryType<Species> TYPE = LamentSpecies.createDefaultType(LamentSpecies::new);
    private Species altSpecies = Species.NULL_SPECIES;

    public void setAltSpecies(Species altSpecies) {
        if (altSpecies != this) {
            this.altSpecies = altSpecies;
        }
    }

    public LamentSpecies(ResourceLocation name, Family family, LeavesProperties leavesProperties) {
        super(name, family, leavesProperties);
    }

    public boolean generate(DynamicTreeGenerationContext context) {
        BlockPos.MutableBlockPos rootPos;
        LevelAccessor level = context.level();
        if (this.altSpecies.isAcceptableSoilForWorldgen(level, (BlockPos)(rootPos = context.rootPos()), level.getBlockState((BlockPos)rootPos))) {
            return this.altSpecies.generate(context);
        }
        return super.generate(context);
    }

    public boolean isAcceptableSoilForWorldgen(LevelAccessor level, BlockPos pos, BlockState soilBlockState) {
        return super.isAcceptableSoilForWorldgen(level, pos, soilBlockState) || this.altSpecies.isAcceptableSoilForWorldgen(level, pos, soilBlockState);
    }

    public boolean isAcceptableSoil(LevelReader level, BlockPos pos, BlockState soilBlockState) {
        return super.isAcceptableSoil(level, pos, soilBlockState) || this.altSpecies.isAcceptableSoil(level, pos, soilBlockState);
    }

    protected boolean transitionToTree(Level level, BlockPos pos, Family family) {
        if (this.altSpecies.isAcceptableSoil((LevelReader)level, pos.below(), level.getBlockState(pos.below()))) {
            return this.altSpecies.transitionToTree(level, pos);
        }
        return super.transitionToTree(level, pos, family);
    }

    public Species generateSeed() {
        return !this.shouldGenerateSeed() || this.seed != null ? this : this.setSeed(RegistryHandler.addItem((ResourceLocation)this.getSeedName(), () -> new Seed(this, this, new Item.Properties().fireResistant()){}));
    }

    public boolean plantSapling(LevelAccessor level, BlockPos pos, boolean locationOverride) {
        FluidState fluidState = level.getFluidState(pos);
        FluidState fluidStateUp = level.getFluidState(pos.above());
        DynamicSaplingBlock sapling = this.getSapling().orElse(null);
        if (sapling != null && fluidState.getType() == Fluids.LAVA && fluidStateUp.getType() == Fluids.EMPTY) {
            return super.plantSapling(level, pos.above(), locationOverride);
        }
        return super.plantSapling(level, pos, locationOverride);
    }
}

