/*
 * Decompiled with CFR 0.152.
 */
package maxhyper.dtbwg.trees;

import com.dtteam.dynamictrees.api.registry.TypedRegistry;
import com.dtteam.dynamictrees.api.voxmap.BlockPosBounds;
import com.dtteam.dynamictrees.api.voxmap.SimpleVoxmap;
import com.dtteam.dynamictrees.block.branch.BranchBlock;
import com.dtteam.dynamictrees.tree.family.Family;
import com.dtteam.dynamictrees.tree.species.Species;
import com.dtteam.dynamictreesplus.block.mushroom.CapProperties;
import com.dtteam.dynamictreesplus.block.mushroom.DynamicCapBlock;
import com.dtteam.dynamictreesplus.block.mushroom.DynamicCapCenterBlock;
import com.dtteam.dynamictreesplus.block.mushroom.MushroomBranchBlock;
import com.dtteam.dynamictreesplus.systems.mushroomlogic.context.MushroomCapContext;
import com.dtteam.dynamictreesplus.tree.HugeMushroomFamily;
import com.dtteam.dynamictreesplus.tree.HugeMushroomSpecies;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import maxhyper.dtbwg.blocks.WartyCapProperties;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public class WartyMushroomFamily
extends HugeMushroomFamily {
    public static final TypedRegistry.EntryType<Family> TYPE = TypedRegistry.newType(WartyMushroomFamily::new);

    public WartyMushroomFamily(ResourceLocation name) {
        super(name);
    }

    protected BranchBlock createBranchBlock(ResourceLocation name) {
        MushroomBranchBlock branch = new MushroomBranchBlock(this, name, this.getProperties()){

            public void destroyMushroomCap(@NotNull Level level, @NotNull BlockPos cutPos, @NotNull Species species, @NotNull ItemStack tool, @NotNull List<BlockPos> endPoints, @NotNull Map<BlockPos, BlockState> destroyedCapBlocks, @NotNull List<BranchBlock.ItemStackPos> drops) {
                if (!(species instanceof HugeMushroomSpecies)) {
                    return;
                }
                HugeMushroomSpecies mushSpecies = (HugeMushroomSpecies)species;
                Family family = species.getFamily();
                if (!(family instanceof HugeMushroomFamily)) {
                    return;
                }
                HugeMushroomFamily family2 = (HugeMushroomFamily)family;
                if (level.isClientSide || endPoints.isEmpty()) {
                    return;
                }
                BlockPosBounds bounds = this.getFamily().expandLeavesBlockBounds(new BlockPosBounds(endPoints));
                SimpleVoxmap capMap = new SimpleVoxmap(bounds);
                for (BlockPos endPos : endPoints) {
                    int age = DynamicCapCenterBlock.getCapAge((Level)level, (BlockPos)endPos.above());
                    if (age < 0) continue;
                    for (BlockPos findPos : mushSpecies.getMushroomShapeKit().getShapeCluster(new MushroomCapContext((LevelAccessor)level, endPos.above(), mushSpecies, Integer.valueOf(age)))) {
                        BlockState findState = level.getBlockState(findPos);
                        if (!family2.isCompatibleCap(mushSpecies, findState, level, findPos)) continue;
                        capMap.setVoxel(findPos.getX(), findPos.getY(), findPos.getZ(), (byte)1);
                    }
                    capMap.setVoxel(endPos, (byte)0);
                }
                ArrayList dropList = new ArrayList();
                for (SimpleVoxmap.VoxmapCell cell : capMap.getAllNonZeroCells()) {
                    BlockPos.MutableBlockPos pos = cell.getPos();
                    BlockState state = level.getBlockState((BlockPos)pos);
                    if (!family2.isCompatibleCap(mushSpecies, state, level, (BlockPos)pos)) continue;
                    dropList.clear();
                    CapProperties cap = this.getCapProperties(state);
                    Block shroomlightBlock = null;
                    if (cap instanceof WartyCapProperties) {
                        WartyCapProperties wartyCap = (WartyCapProperties)cap;
                        shroomlightBlock = wartyCap.getShroomlightBlock();
                    }
                    dropList.addAll(cap.getDrops(level, (BlockPos)pos, tool, species));
                    BlockPos imPos = pos.immutable();
                    BlockPos relPos = imPos.subtract((Vec3i)cutPos);
                    level.setBlock(imPos, Blocks.AIR.defaultBlockState(), 3);
                    if (shroomlightBlock != null) {
                        BlockState upState = level.getBlockState(imPos.above());
                        BlockState downState = level.getBlockState(imPos.below());
                        if (upState.is(shroomlightBlock)) {
                            level.destroyBlock(imPos.above(), true);
                        }
                        if (downState.is(shroomlightBlock)) {
                            level.destroyBlock(imPos.below(), true);
                        }
                    }
                    destroyedCapBlocks.put(relPos, state);
                    dropList.forEach(i -> drops.add(new BranchBlock.ItemStackPos(i, relPos)));
                }
            }

            private CapProperties getCapProperties(BlockState state) {
                if (state.getBlock() instanceof DynamicCapBlock) {
                    return Optional.of((DynamicCapBlock)state.getBlock()).map(block -> block.getProperties(state)).orElse(CapProperties.NULL);
                }
                return state.getBlock() instanceof DynamicCapCenterBlock ? Optional.of((DynamicCapCenterBlock)state.getBlock()).map(block -> block.getProperties(state)).orElse(CapProperties.NULL) : CapProperties.NULL;
            }
        };
        if (this.isFireProof()) {
            branch.setFireSpreadSpeed(0).setFlammability(0);
        }
        return branch;
    }
}

