/*
 * Decompiled with CFR 0.152.
 */
package maxhyper.dtbwg.blocks;

import com.dtteam.dynamictrees.api.registry.TypedRegistry;
import com.dtteam.dynamictrees.systems.poissondisc.Vec2i;
import com.dtteam.dynamictreesplus.block.mushroom.CapProperties;
import com.dtteam.dynamictreesplus.block.mushroom.DynamicCapBlock;
import com.dtteam.dynamictreesplus.block.mushroom.DynamicCapCenterBlock;
import com.dtteam.dynamictreesplus.systems.mushroomlogic.MushroomCapDisc;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;

public class EmburGelCapProperties
extends CapProperties {
    public static final TypedRegistry.EntryType<CapProperties> TYPE = TypedRegistry.newType(EmburGelCapProperties::new);
    protected float droopyFirstLevelChance = 0.5f;
    protected float droopySecondLevelChance = 0.25f;
    protected int minAgeForSecondLevelDroop = 4;

    public EmburGelCapProperties(ResourceLocation registryName) {
        super(registryName);
    }

    protected String getBlockRegistryNameSuffix() {
        return "_gel";
    }

    protected String getCenterBlockRegistryNameSuffix() {
        return "_gel_center";
    }

    public BlockBehaviour.Properties getDefaultBlockProperties(MapColor mapColor) {
        return BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.CLAY).mapColor(MapColor.TERRACOTTA_YELLOW).sound(SoundType.HONEY_BLOCK).noOcclusion().speedFactor(1.3f);
    }

    protected DynamicCapCenterBlock createDynamicCapCenter(BlockBehaviour.Properties properties) {
        return new DynamicCapCenterBlock(this, properties){

            public List<BlockPos> getRing(LevelAccessor level, BlockPos pos, int radius) {
                List ring = MushroomCapDisc.getPrecomputedRing((int)radius);
                LinkedList<BlockPos> positions = new LinkedList<BlockPos>();
                for (Vec2i vec : ring) {
                    BlockPos ringPos = new BlockPos(pos.getX() + vec.x, pos.getY(), pos.getZ() + vec.z);
                    if (!this.properties.isPartOfCap(level.getBlockState(ringPos))) continue;
                    positions.add(ringPos);
                    if (this.properties.isPartOfCap(level.getBlockState(ringPos.below(2)))) {
                        positions.add(ringPos.below(2));
                    }
                    if (!this.properties.isPartOfCap(level.getBlockState(ringPos.below()))) continue;
                    positions.add(ringPos.below());
                }
                return positions;
            }

            public void clearRing(LevelAccessor level, BlockPos pos, int radius) {
                List ring = MushroomCapDisc.getPrecomputedRing((int)radius);
                for (Vec2i vec : ring) {
                    BlockPos ringPos = new BlockPos(pos.getX() + vec.x, pos.getY(), pos.getZ() + vec.z);
                    if (!this.properties.isPartOfCap(level.getBlockState(ringPos))) continue;
                    if (this.properties.isPartOfCap(level.getBlockState(ringPos.below(2)))) {
                        level.setBlock(ringPos.below(2), Blocks.AIR.defaultBlockState(), 2);
                    }
                    if (this.properties.isPartOfCap(level.getBlockState(ringPos.below()))) {
                        level.setBlock(ringPos.below(), Blocks.AIR.defaultBlockState(), 2);
                    }
                    level.setBlock(ringPos, Blocks.AIR.defaultBlockState(), 2);
                }
            }

            public boolean placeRing(LevelAccessor level, BlockPos pos, int radius, int step, boolean yMoved, boolean negFactor) {
                List ring = MushroomCapDisc.getPrecomputedRing((int)radius);
                int placed = 0;
                int notPlaced = 0;
                int age = 0;
                for (int i = 0; i < 8; ++i) {
                    BlockPos searchPos = pos.above((negFactor ? -1 : 1) * i);
                    BlockState searchState = level.getBlockState(searchPos);
                    if (!searchState.hasProperty((Property)AGE)) continue;
                    age = (Integer)searchState.getValue((Property)AGE);
                    break;
                }
                boolean lastRing = step == age;
                for (Vec2i vec : ring) {
                    BlockPos ringPos = new BlockPos(pos.getX() + vec.x, pos.getY(), pos.getZ() + vec.z);
                    if (1.canCapReplace((BlockState)level.getBlockState(ringPos))) {
                        BlockState placeCapState = this.getStateForAge(this.properties, step, new Vec2i(-vec.x, -vec.z), yMoved, negFactor, this.properties.isPartOfCap(level.getBlockState(ringPos.above())), lastRing);
                        level.setBlock(ringPos, placeCapState, 2);
                        if (lastRing && level.getRandom().nextFloat() < EmburGelCapProperties.this.droopyFirstLevelChance && 1.canCapReplace((BlockState)level.getBlockState(ringPos.below())) && step < 8) {
                            BlockState droopyCapState1 = this.properties.getDynamicCapState(step + 1, new boolean[]{true, false, true, true, true, true});
                            level.setBlock(ringPos.below(), droopyCapState1, 2);
                            if (level.getRandom().nextFloat() < EmburGelCapProperties.this.droopySecondLevelChance && 1.canCapReplace((BlockState)level.getBlockState(ringPos.below(2))) && age >= EmburGelCapProperties.this.minAgeForSecondLevelDroop && step < 7) {
                                BlockState droopyCapState2 = this.properties.getDynamicCapState(step + 2, new boolean[]{true, false, true, true, true, true});
                                level.setBlock(ringPos.below(2), (BlockState)droopyCapState2.setValue((Property)DynamicCapBlock.DISTANCE, (Comparable)Integer.valueOf(step + 2)), 2);
                            }
                        }
                        ++placed;
                        continue;
                    }
                    ++notPlaced;
                }
                return placed >= notPlaced;
            }

            @Nonnull
            private BlockState getStateForAge(CapProperties properties, int age, Vec2i centerDirection, boolean yMoved, boolean negativeFactor, boolean topIsCap, boolean lastRing) {
                boolean[] dirs = new boolean[]{lastRing, !topIsCap, true, true, true, true};
                if (yMoved || age == 1) {
                    for (Direction dir : Direction.Plane.HORIZONTAL) {
                        float dot = dir.getNormal().getX() * centerDirection.x + dir.getNormal().getZ() * centerDirection.z;
                        if (!(dot >= 0.0f)) continue;
                        dirs[negativeFactor ? dir.getOpposite().ordinal() : dir.ordinal()] = false;
                    }
                }
                return properties.getDynamicCapState(age, dirs);
            }
        };
    }
}

