/*
 * Decompiled with CFR 0.152.
 */
package maxhyper.dtbwg.blocks;

import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BucketPickup;
import net.minecraft.world.level.block.LiquidBlockContainer;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;

public interface SimpleLavaloggedBlock
extends BucketPickup,
LiquidBlockContainer {
    public static final BooleanProperty LAVALOGGED = BooleanProperty.create((String)"lavalogged");

    default public boolean canPlaceLiquid(@Nullable Player player, BlockGetter level, BlockPos pos, BlockState state, Fluid fluid) {
        return (Boolean)state.getValue((Property)LAVALOGGED) == false && fluid == Fluids.LAVA;
    }

    default public boolean placeLiquid(LevelAccessor level, BlockPos pos, BlockState state, FluidState fluidState) {
        if (!((Boolean)state.getValue((Property)LAVALOGGED)).booleanValue() && fluidState.getType() == Fluids.LAVA) {
            if (!level.isClientSide()) {
                level.setBlock(pos, (BlockState)state.setValue((Property)LAVALOGGED, (Comparable)Boolean.valueOf(true)), 3);
                level.scheduleTick(pos, fluidState.getType(), fluidState.getType().getTickDelay((LevelReader)level));
            }
            return true;
        }
        return false;
    }

    default public ItemStack pickupBlock(@Nullable Player player, LevelAccessor level, BlockPos pos, BlockState state) {
        if (((Boolean)state.getValue((Property)LAVALOGGED)).booleanValue()) {
            level.setBlock(pos, (BlockState)state.setValue((Property)LAVALOGGED, (Comparable)Boolean.valueOf(false)), 3);
            if (!state.canSurvive((LevelReader)level, pos)) {
                level.destroyBlock(pos, true);
            }
            return new ItemStack((ItemLike)Items.LAVA_BUCKET);
        }
        return ItemStack.EMPTY;
    }

    default public Optional<SoundEvent> getPickupSound(BlockState state) {
        return Fluids.LAVA.getPickupSound();
    }
}

