/*
 * Decompiled with CFR 0.152.
 */
package maxhyper.dtbwg.cancellers;

import com.dtteam.dynamictrees.api.worldgen.BiomePropertySelectors;
import com.dtteam.dynamictrees.api.worldgen.FeatureCanceller;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.WeightedPlacedFeature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.RandomFeatureConfiguration;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;

public class BWGTreeFeatureCanceller<T extends FeatureConfiguration>
extends FeatureCanceller {
    private final Class<T> treeFeatureConfigClass;

    public BWGTreeFeatureCanceller(ResourceLocation registryName, Class<T> treeFeatureConfigClass) {
        super(registryName);
        this.treeFeatureConfigClass = treeFeatureConfigClass;
    }

    public boolean shouldCancel(ConfiguredFeature<?, ?> configuredFeature, BiomePropertySelectors.NormalFeatureCancellation featureCancellations) {
        FeatureConfiguration featureConfig = configuredFeature.config();
        if (featureConfig instanceof RandomFeatureConfiguration) {
            RandomFeatureConfiguration RFC = (RandomFeatureConfiguration)featureConfig;
            return this.doesContainTrees(RFC, featureCancellations);
        }
        if (this.treeFeatureConfigClass.isInstance(featureConfig)) {
            String nameSpace = "";
            ConfiguredFeature nextConfiguredFeature = (ConfiguredFeature)configuredFeature.getFeatures().findFirst().get();
            FeatureConfiguration nextFeatureConfig = nextConfiguredFeature.config();
            ResourceLocation featureRegistryName = BuiltInRegistries.FEATURE.getKey((Object)nextConfiguredFeature.feature());
            if (featureRegistryName != null) {
                nameSpace = featureRegistryName.getNamespace();
            }
            if (this.treeFeatureConfigClass.isInstance(nextFeatureConfig) && !nameSpace.equals("") && featureCancellations.shouldCancelNamespace(nameSpace)) {
                return true;
            }
            if (nextFeatureConfig instanceof RandomFeatureConfiguration) {
                return this.doesContainTrees((RandomFeatureConfiguration)nextFeatureConfig, featureCancellations);
            }
        }
        return false;
    }

    private boolean doesContainTrees(RandomFeatureConfiguration featureConfig, BiomePropertySelectors.NormalFeatureCancellation featureCancellations) {
        for (WeightedPlacedFeature feature : featureConfig.features) {
            PlacedFeature currentPlacedFeature = (PlacedFeature)feature.feature.value();
            ConfiguredFeature currentConfiguredFeature = (ConfiguredFeature)currentPlacedFeature.feature().value();
            ResourceLocation featureRegistryName = BuiltInRegistries.FEATURE.getKey((Object)((ConfiguredFeature)currentConfiguredFeature.getFeatures().findFirst().get()).feature());
            if (this.treeFeatureConfigClass.isInstance(currentConfiguredFeature.config()) && featureRegistryName != null && featureCancellations.shouldCancelNamespace(featureRegistryName.getNamespace())) {
                return true;
            }
            FeatureConfiguration featureConfiguration = currentConfiguredFeature.config();
            if (!(featureConfiguration instanceof RandomFeatureConfiguration)) continue;
            RandomFeatureConfiguration RFC = (RandomFeatureConfiguration)featureConfiguration;
            return this.doesContainTrees(RFC, featureCancellations);
        }
        return false;
    }
}

