/*
 * Decompiled with CFR 0.152.
 */
package maxhyper.dtbwg.cancellers;

import com.dtteam.dynamictrees.api.worldgen.BiomePropertySelectors;
import com.dtteam.dynamictrees.api.worldgen.FeatureCanceller;
import com.dtteam.dynamictrees.api.worldgen.RandomXOR;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.configurations.BlockColumnConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.RandomPatchConfiguration;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.feature.stateproviders.SimpleStateProvider;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;

public class CactusFeatureCanceller<T extends Block>
extends FeatureCanceller {
    private static final RandomSource PLACEHOLDER_RAND = new RandomXOR();
    private final Class<T> cactusBlockClass;

    public CactusFeatureCanceller(ResourceLocation registryName, Class<T> cactusBlockClass) {
        super(registryName);
        this.cactusBlockClass = cactusBlockClass;
    }

    public boolean shouldCancel(ConfiguredFeature<?, ?> configuredFeature, BiomePropertySelectors.NormalFeatureCancellation featureCancellations) {
        ResourceLocation featureRegistryName = BuiltInRegistries.FEATURE.getKey((Object)configuredFeature.feature());
        if (featureRegistryName == null) {
            return false;
        }
        FeatureConfiguration featureConfig = configuredFeature.config();
        if (featureConfig instanceof RandomPatchConfiguration) {
            RandomPatchConfiguration randomPatchConfiguration = (RandomPatchConfiguration)featureConfig;
            PlacedFeature placedFeature = (PlacedFeature)randomPatchConfiguration.feature().value();
            featureConfig = ((ConfiguredFeature)placedFeature.feature().value()).config();
        }
        if (!(featureConfig instanceof BlockColumnConfiguration)) {
            return featureCancellations.shouldCancelNamespace(featureRegistryName.getNamespace());
        }
        BlockColumnConfiguration blockColumnConfiguration = (BlockColumnConfiguration)featureConfig;
        for (BlockColumnConfiguration.Layer layer : blockColumnConfiguration.layers()) {
            BlockStateProvider stateProvider = layer.state();
            if (!(stateProvider instanceof SimpleStateProvider) || !this.cactusBlockClass.isInstance(stateProvider.getState(PLACEHOLDER_RAND, BlockPos.ZERO).getBlock())) continue;
            return true;
        }
        return false;
    }
}

