/*
 * Decompiled with CFR 0.152.
 */
package maxhyper.dtbwg.genfeatures;

import com.dtteam.dynamictrees.api.configuration.ConfigurationProperty;
import com.dtteam.dynamictrees.api.network.MapSignal;
import com.dtteam.dynamictrees.api.network.NodeInspector;
import com.dtteam.dynamictrees.block.branch.BranchBlock;
import com.dtteam.dynamictrees.systems.genfeature.GenFeature;
import com.dtteam.dynamictrees.systems.genfeature.GenFeatureConfiguration;
import com.dtteam.dynamictrees.systems.genfeature.context.PostGenerationContext;
import com.dtteam.dynamictrees.systems.genfeature.context.PostGrowContext;
import com.dtteam.dynamictrees.systems.nodemapper.FindEndsNode;
import com.dtteam.dynamictrees.tree.TreeHelper;
import com.dtteam.dynamictrees.tree.species.Species;
import com.dtteam.dynamictrees.utility.CoordUtils;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.VineBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;

public class LushVinesGenFeature
extends GenFeature {
    protected final BooleanProperty[] sideVineStates = new BooleanProperty[]{null, null, VineBlock.NORTH, VineBlock.SOUTH, VineBlock.WEST, VineBlock.EAST};
    public static final ConfigurationProperty<Integer> MAX_LENGTH = ConfigurationProperty.integer((String)"max_length");
    public static final ConfigurationProperty<Block> BLOCK = ConfigurationProperty.block((String)"block");
    public static final ConfigurationProperty<Block> TIP_BLOCK = ConfigurationProperty.block((String)"tip_block");
    public static final ConfigurationProperty<Integer> BERRIES_CHANCE = ConfigurationProperty.integer((String)"berries_chance");
    public static final BooleanProperty BERRIES = BooleanProperty.create((String)"berries");

    public LushVinesGenFeature(ResourceLocation registryName) {
        super(registryName);
    }

    protected void registerProperties() {
        this.register(new ConfigurationProperty[]{QUANTITY, MAX_LENGTH, VERTICAL_SPREAD, RAY_DISTANCE, BLOCK, TIP_BLOCK, BERRIES_CHANCE, FRUITING_RADIUS});
    }

    public GenFeatureConfiguration createDefaultConfiguration() {
        return (GenFeatureConfiguration)((GenFeatureConfiguration)((GenFeatureConfiguration)((GenFeatureConfiguration)((GenFeatureConfiguration)((GenFeatureConfiguration)((GenFeatureConfiguration)((GenFeatureConfiguration)super.createDefaultConfiguration().with(QUANTITY, (Object)4)).with(MAX_LENGTH, (Object)8)).with(VERTICAL_SPREAD, (Object)Float.valueOf(60.0f))).with(RAY_DISTANCE, (Object)Float.valueOf(5.0f))).with(BLOCK, (Object)Blocks.VINE)).with(TIP_BLOCK, null)).with(BERRIES_CHANCE, (Object)0)).with(FRUITING_RADIUS, (Object)-1);
    }

    protected boolean postGenerate(GenFeatureConfiguration configuration, PostGenerationContext context) {
        if (!context.isWorldGen() || context.endPoints().isEmpty()) {
            return false;
        }
        int quantity = (Integer)configuration.get(QUANTITY);
        for (int i = 0; i < quantity; ++i) {
            BlockPos endPoint = (BlockPos)context.endPoints().get(context.random().nextInt(context.endPoints().size()));
            this.addVerticalVines(configuration, context.level(), context.species(), context.pos(), endPoint, true);
        }
        return true;
    }

    protected boolean postGrow(GenFeatureConfiguration configuration, PostGrowContext context) {
        LevelAccessor level = context.level();
        BlockPos rootPos = context.pos();
        Species species = context.species();
        int fruitingRadius = (Integer)configuration.get(FRUITING_RADIUS);
        if (fruitingRadius < 0 || context.fertility() < 1) {
            return false;
        }
        BlockState blockState = level.getBlockState(context.treePos());
        BranchBlock branch = TreeHelper.getBranch((BlockState)blockState);
        if (branch != null && branch.getRadius(blockState) >= fruitingRadius && context.natural() && species.seasonalFruitProductionFactor(context.levelContext(), rootPos) > level.getRandom().nextFloat()) {
            FindEndsNode endFinder = new FindEndsNode();
            TreeHelper.startAnalysisFromRoot((LevelAccessor)level, (BlockPos)rootPos, (MapSignal)new MapSignal(new NodeInspector[]{endFinder}));
            List endPoints = endFinder.getEnds();
            int qty = (Integer)configuration.get(QUANTITY);
            if (!endPoints.isEmpty()) {
                for (int i = 0; i < qty; ++i) {
                    BlockPos endPoint = (BlockPos)endPoints.get(level.getRandom().nextInt(endPoints.size()));
                    this.addVerticalVines(configuration, level, species, rootPos, endPoint, false);
                }
                return true;
            }
        }
        return true;
    }

    protected void addVerticalVines(GenFeatureConfiguration configuration, LevelAccessor level, Species species, BlockPos rootPos, BlockPos branchPos, boolean worldgen) {
        BlockPos vinePos = CoordUtils.getRayTraceFruitPos((LevelAccessor)level, (Species)species, (BlockPos)rootPos, (BlockPos)branchPos, (boolean)worldgen);
        if (!worldgen || vinePos == BlockPos.ZERO) {
            return;
        }
        this.placeVines(level, vinePos, ((Block)configuration.get(BLOCK)).defaultBlockState(), (Integer)configuration.get(MAX_LENGTH), configuration.getAsOptional(TIP_BLOCK).map(Block::defaultBlockState).orElse(null), worldgen, configuration);
    }

    protected void placeVines(LevelAccessor level, BlockPos vinePos, BlockState vinesState, int maxLength, @Nullable BlockState tipState, boolean worldGen, GenFeatureConfiguration configuration) {
        int len = worldGen ? Mth.clamp((int)(level.getRandom().nextInt(maxLength) + 3), (int)3, (int)maxLength) : 1;
        BlockPos.MutableBlockPos mPos = new BlockPos.MutableBlockPos(vinePos.getX(), vinePos.getY(), vinePos.getZ());
        int berriesChance = (Integer)configuration.get(BERRIES_CHANCE);
        tipState = tipState == null ? vinesState : tipState;
        for (int i = 0; i < len; ++i) {
            BlockState currentState;
            if (level.isEmptyBlock((BlockPos)mPos)) {
                boolean hasBerries = level.getRandom().nextInt(10) < berriesChance;
                BlockState blockState = currentState = i == len - 1 ? tipState : vinesState;
                if (hasBerries && currentState.hasProperty((Property)BERRIES)) {
                    currentState = (BlockState)currentState.setValue((Property)BERRIES, (Comparable)Boolean.valueOf(true));
                }
            } else {
                if (i <= 0) break;
                mPos.setY(mPos.getY() + 1);
                level.setBlock((BlockPos)mPos, tipState, 3);
                break;
            }
            level.setBlock((BlockPos)mPos, currentState, 3);
            mPos.setY(mPos.getY() - 1);
        }
    }
}

