/*
 * Decompiled with CFR 0.152.
 */
package maxhyper.dtbwg.growthlogic;

import com.dtteam.dynamictrees.block.branch.BranchBlock;
import com.dtteam.dynamictrees.systems.GrowSignal;
import com.dtteam.dynamictrees.systems.growthlogic.GrowthLogicKitConfiguration;
import com.dtteam.dynamictrees.systems.growthlogic.context.DirectionManipulationContext;
import com.dtteam.dynamictrees.utility.CoordUtils;
import maxhyper.dtbwg.growthlogic.VariateHeightLogic;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;

public class BaobabLogic
extends VariateHeightLogic {
    public BaobabLogic(ResourceLocation registryName) {
        super(registryName);
    }

    @Override
    protected GrowthLogicKitConfiguration createDefaultConfiguration() {
        return (GrowthLogicKitConfiguration)super.createDefaultConfiguration().with(HEIGHT_VARIATION, (Object)4);
    }

    public int[] populateDirectionProbabilityMap(GrowthLogicKitConfiguration configuration, DirectionManipulationContext context) {
        Direction relativePosToRoot;
        Level world = context.level();
        GrowSignal signal = context.signal();
        int[] probMap = context.probMap();
        BlockPos pos = context.pos();
        Direction originDir = signal.dir.getOpposite();
        if (!signal.isInTrunk() && (relativePosToRoot = Direction.fromDelta((int)signal.delta.getX(), (int)0, (int)signal.delta.getY())) != null) {
            if (signal.energy > 2.0f) {
                probMap[Direction.DOWN.ordinal()] = 0;
                for (Direction dir : CoordUtils.HORIZONTALS) {
                    probMap[dir.ordinal()] = 0;
                }
            }
            boolean isBranchUp = world.getBlockState(pos.offset(relativePosToRoot.getNormal())).getBlock() instanceof BranchBlock;
            boolean isBranchSide = world.getBlockState(pos.above()).getBlock() instanceof BranchBlock;
            probMap[Direction.UP.ordinal()] = isBranchUp && !isBranchSide ? 0 : 2;
            probMap[relativePosToRoot.ordinal()] = isBranchSide && !isBranchUp ? 0 : 3;
        }
        probMap[originDir.ordinal()] = 0;
        return probMap;
    }
}

