/*
 * Decompiled with CFR 0.152.
 */
package maxhyper.dtbwg.growthlogic;

import com.dtteam.dynamictrees.systems.GrowSignal;
import com.dtteam.dynamictrees.systems.growthlogic.ConiferLogic;
import com.dtteam.dynamictrees.systems.growthlogic.GrowthLogicKitConfiguration;
import com.dtteam.dynamictrees.systems.growthlogic.context.DirectionManipulationContext;
import com.dtteam.dynamictrees.tree.TreeHelper;
import com.dtteam.dynamictrees.utility.CoordUtils;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.state.BlockState;

public class PineLogic
extends ConiferLogic {
    public PineLogic(ResourceLocation registryName) {
        super(registryName);
    }

    protected GrowthLogicKitConfiguration createDefaultConfiguration() {
        return (GrowthLogicKitConfiguration)((GrowthLogicKitConfiguration)super.createDefaultConfiguration().with(ENERGY_DIVISOR, (Object)Float.valueOf(10.0f))).with(HORIZONTAL_LIMITER, (Object)Float.valueOf(2.0f));
    }

    public int[] populateDirectionProbabilityMap(GrowthLogicKitConfiguration configuration, DirectionManipulationContext context) {
        int[] probMap = context.probMap();
        GrowSignal signal = context.signal();
        probMap[0] = 0;
        probMap[1] = signal.isInTrunk() ? context.species().getUpProbability() : 0;
        probMap[5] = !signal.isInTrunk() || signal.isInTrunk() && context.radius() > 1 ? 2 : 0;
        probMap[4] = probMap[5];
        probMap[3] = probMap[5];
        probMap[2] = probMap[5];
        if (signal.isInTrunk()) {
            for (Direction dir : CoordUtils.HORIZONTALS) {
                if (!TreeHelper.isBranch((BlockState)context.level().getBlockState(context.pos().offset(dir.getNormal())))) continue;
                probMap[5] = 0;
                probMap[4] = 0;
                probMap[3] = 0;
                probMap[2] = 0;
                probMap[dir.ordinal()] = 2;
                break;
            }
        }
        probMap[signal.dir.getOpposite().ordinal()] = 0;
        int n = signal.dir.ordinal();
        probMap[n] = probMap[n] + (signal.isInTrunk() ? 0 : (signal.numTurns == 1 ? 2 : 1));
        return probMap;
    }
}

