/*
 * Decompiled with CFR 0.152.
 */
package maxhyper.dtbwg.init;

import com.dtteam.dynamictrees.tree.TreeHelper;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import maxhyper.dtbwg.blocks.DynamicWitchHazelBranch;
import maxhyper.dtbwg.init.DTBWGRegistries;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import net.potionstudios.biomeswevegone.world.level.block.BWGBlocks;
import net.potionstudios.biomeswevegone.world.level.block.plants.tree.branch.TreeBranchBlock;

@EventBusSubscriber(modid="dtbwg")
public class SideBranchPlaceEventHandler {
    static final Map<Supplier<TreeBranchBlock>, Supplier<DynamicWitchHazelBranch>> branches = ImmutableMap.builder().put((Object)BWGBlocks.WITCH_HAZEL_BRANCH, DTBWGRegistries.WITCH_HAZEL_BRANCH).build();

    @SubscribeEvent
    public static void onPlayerRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        BlockPos branchPos;
        BlockItem handBlockItem;
        Block block;
        Player player = event.getEntity();
        InteractionHand hand = event.getHand();
        ItemStack heldItem = player.getItemInHand(hand);
        Item handItem = player.getItemInHand(hand).getItem();
        Block bloomBranch = null;
        if (handItem instanceof BlockItem && (block = (handBlockItem = (BlockItem)handItem).getBlock()) instanceof TreeBranchBlock) {
            TreeBranchBlock handBlock = (TreeBranchBlock)block;
            Supplier normalBranch = branches.keySet().stream().filter(i -> handBlock.equals(i.get())).findFirst().orElse(null);
            if (normalBranch != null) {
                bloomBranch = (Block)branches.get(normalBranch).get();
            }
        }
        if (bloomBranch == null) {
            return;
        }
        Level world = event.getLevel();
        BlockState state = world.getBlockState(branchPos = event.getPos());
        if (!TreeHelper.isBranch((BlockState)state) || TreeHelper.getRadius((BlockGetter)world, (BlockPos)branchPos) < 3) {
            return;
        }
        BlockPos pos = branchPos.relative(Objects.requireNonNull(event.getFace()));
        if (!world.getBlockState(pos).canBeReplaced()) {
            return;
        }
        if (!player.isCreative()) {
            heldItem.shrink(1);
        }
        world.playSound(null, pos, bloomBranch.getSoundType(state, (LevelReader)world, pos, (Entity)player).getPlaceSound(), SoundSource.BLOCKS, 1.0f, 0.8f);
        BlockPlaceContext context = new BlockPlaceContext(player, hand, heldItem, new BlockHitResult(player.getEyePosition(1.0f), event.getFace(), branchPos, false));
        BlockState placeState = bloomBranch.getStateForPlacement(context);
        if (placeState == null) {
            return;
        }
        world.setBlock(pos, placeState, 3);
        event.setCancellationResult(InteractionResult.SUCCESS);
        event.setCanceled(true);
    }
}

