/*
 * Decompiled with CFR 0.152.
 */
package maxhyper.dtbwg.mushroomshape;

import com.dtteam.dynamictrees.api.configuration.ConfigurationProperty;
import com.dtteam.dynamictrees.utility.CoordUtils;
import com.dtteam.dynamictreesplus.block.mushroom.DynamicCapCenterBlock;
import com.dtteam.dynamictreesplus.systems.mushroomlogic.MushroomShapeConfiguration;
import com.dtteam.dynamictreesplus.systems.mushroomlogic.context.MushroomCapContext;
import com.dtteam.dynamictreesplus.systems.mushroomlogic.shapekits.MushroomShapeKit;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public class LinearShape
extends MushroomShapeKit {
    public static final ConfigurationProperty<Integer> POINTED_TIP_AGE = ConfigurationProperty.integer((String)"pointed_tip_max_age");
    public static final ConfigurationProperty<Float> FACTOR = ConfigurationProperty.floatProperty((String)"factor");
    public static final ConfigurationProperty<Float> FACTOR_VARIATION = ConfigurationProperty.floatProperty((String)"factor_variation");

    public LinearShape(ResourceLocation registryName) {
        super(registryName);
    }

    @NotNull
    public MushroomShapeConfiguration getDefaultConfiguration() {
        return (MushroomShapeConfiguration)((MushroomShapeConfiguration)((MushroomShapeConfiguration)((MushroomShapeConfiguration)((MushroomShapeConfiguration)((MushroomShapeConfiguration)this.defaultConfiguration).with(CHANCE_TO_AGE, (Object)Float.valueOf(0.75f))).with(MAX_CAP_AGE, (Object)6)).with(POINTED_TIP_AGE, (Object)0)).with(FACTOR, (Object)Float.valueOf(1.0f))).with(FACTOR_VARIATION, (Object)Float.valueOf(0.0f));
    }

    protected void registerProperties() {
        this.register(new ConfigurationProperty[]{CHANCE_TO_AGE, MAX_CAP_AGE, POINTED_TIP_AGE, FACTOR, FACTOR_VARIATION});
    }

    public void generateMushroomCap(MushroomShapeConfiguration configuration, MushroomCapContext context) {
        this.placeRing(configuration, context, Math.min(context.age(), (Integer)configuration.get(MAX_CAP_AGE)), ringAction.PLACE);
    }

    public void clearMushroomCap(MushroomShapeConfiguration configuration, MushroomCapContext context) {
        this.placeRing(configuration, context, context.age(), ringAction.CLEAR);
    }

    public List<BlockPos> getShapeCluster(MushroomShapeConfiguration configuration, MushroomCapContext context) {
        return this.placeRing(configuration, context, context.age(), ringAction.GET);
    }

    public int getMaxCapAge(MushroomShapeConfiguration configuration) {
        return (Integer)configuration.get(MAX_CAP_AGE);
    }

    public float getChanceToAge(MushroomShapeConfiguration configuration) {
        return ((Float)configuration.get(CHANCE_TO_AGE)).floatValue();
    }

    @Nonnull
    private List<BlockPos> placeRing(MushroomShapeConfiguration configuration, MushroomCapContext context, int age, ringAction action) {
        DynamicCapCenterBlock centerBlock = context.species().getCapProperties().getDynamicCapCenterBlock().orElse(null);
        LinkedList<BlockPos> ringPositions = new LinkedList<BlockPos>();
        if (centerBlock == null) {
            return ringPositions;
        }
        float rand = (float)CoordUtils.coordHashCode((BlockPos)new BlockPos(context.pos().getX(), 0, context.pos().getZ()), (int)2) / 65535.0f;
        float factor = ((Float)configuration.get(FACTOR)).floatValue() + ((Float)configuration.get(FACTOR_VARIATION)).floatValue() * (2.0f * rand - 1.0f);
        int y = 0;
        int radius = 1;
        for (int i = 1; i <= age; ++i) {
            boolean moveY;
            boolean tip = i == 1 && age > (Integer)configuration.get(POINTED_TIP_AGE);
            boolean bl = moveY = !tip && (factor < 1.0f || i % (int)factor == 0);
            if (moveY) {
                ++y;
            }
            BlockPos pos = context.pos().below(y);
            if (action == ringAction.CLEAR) {
                centerBlock.clearRing(context.level(), pos, radius);
            } else if (action == ringAction.PLACE) {
                if (!centerBlock.placeRing(context.level(), pos, radius, i, i > 1 || moveY, factor < 0.0f)) {
                    break;
                }
            } else if (action == ringAction.GET) {
                ringPositions.addAll(centerBlock.getRing(context.level(), pos, radius));
            }
            if (!(factor > 1.0f) && i % (int)(1.0f / factor) != 0) continue;
            ++radius;
        }
        ringPositions.add(context.pos());
        return ringPositions;
    }

    static enum ringAction {
        PLACE,
        CLEAR,
        GET;

    }
}

