/*
 * Decompiled with CFR 0.152.
 */
package maxhyper.dtbwg.trees;

import com.dtteam.dynamictrees.api.registry.TypedRegistry;
import com.dtteam.dynamictrees.block.leaves.LeavesProperties;
import com.dtteam.dynamictrees.tree.family.Family;
import com.dtteam.dynamictrees.tree.species.Species;
import com.dtteam.dynamictrees.worldgen.JoCode;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockState;

public class GenUnderwaterSpecies
extends Species {
    public static final TypedRegistry.EntryType<Species> TYPE = GenUnderwaterSpecies.createDefaultType(GenUnderwaterSpecies::new);
    private static final int maxDepth = 7;

    public GenUnderwaterSpecies(ResourceLocation name, Family family, LeavesProperties leavesProperties) {
        super(name, family, leavesProperties);
    }

    public boolean isAcceptableSoilForWorldgen(LevelAccessor world, BlockPos pos, BlockState soilBlockState) {
        boolean isAcceptableSoil = this.isAcceptableSoil((LevelReader)world, pos, soilBlockState);
        if (isAcceptableSoil && this.isWater(soilBlockState)) {
            for (int i = 1; i <= 7; ++i) {
                BlockPos down = pos.below(i);
                BlockState downState = world.getBlockState(down);
                if (this.isWater(downState) || !this.isAcceptableSoilForWorldgen(downState)) continue;
                return true;
            }
            return false;
        }
        return isAcceptableSoil;
    }

    public BlockPos preGeneration(LevelAccessor world, BlockPos.MutableBlockPos rootPos, int radius, Direction facing, boolean worldGen, JoCode joCode) {
        if (this.isWater(world.getBlockState((BlockPos)rootPos))) {
            for (int i = 1; i <= 7; ++i) {
                rootPos.move(Direction.DOWN);
                BlockState downState = world.getBlockState((BlockPos)rootPos);
                if (!this.isWater(downState) && this.isAcceptableSoilForWorldgen(downState)) break;
            }
        }
        return super.preGeneration(world, rootPos, radius, facing, worldGen, joCode);
    }
}

