/*
 * Decompiled with CFR 0.152.
 */
package maxhyper.dtbwg.trees;

import com.dtteam.dynamictrees.api.lazyvalue.MutableLazyValue;
import com.dtteam.dynamictrees.api.registry.RegistryHandler;
import com.dtteam.dynamictrees.api.registry.TypedRegistry;
import com.dtteam.dynamictrees.block.branch.BranchBlock;
import com.dtteam.dynamictrees.block.branch.ThickBranchBlock;
import com.dtteam.dynamictrees.data.DTDataProvider;
import com.dtteam.dynamictrees.data.Generator;
import com.dtteam.dynamictrees.data.generator.BranchStateGenerator;
import com.dtteam.dynamictrees.tree.family.Family;
import com.dtteam.dynamictrees.utility.Optionals;
import com.dtteam.dynamictrees.utility.ResourceLocationUtils;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.NotNull;

public class ImbuedLogFamily
extends Family {
    public static final TypedRegistry.EntryType<Family> TYPE = TypedRegistry.newType(ImbuedLogFamily::new);
    protected Supplier<BranchBlock> imbuedBranch;
    protected Block primitiveImbuedLog;
    protected final MutableLazyValue<ImbuedBranchStateGenerator> imbuedBranchStateGenerator = MutableLazyValue.supplied(ImbuedBranchStateGenerator::new);

    public ImbuedLogFamily(ResourceLocation name) {
        super(name);
    }

    public void setupBlocks() {
        super.setupBlocks();
        this.imbuedBranch = this.setupBranch(this.createImbuedBranch(this.getBranchName("imbued_")), false);
    }

    protected BranchBlock createImbuedBranchBlock(ResourceLocation name) {
        ThickBranchBlock branch = new ThickBranchBlock(this, name, this.getProperties()){

            public Optional<Block> getPrimitiveLog() {
                Family family = this.getFamily();
                if (family instanceof ImbuedLogFamily) {
                    ImbuedLogFamily imbuedLogFamily = (ImbuedLogFamily)family;
                    return imbuedLogFamily.getPrimitiveImbuedLog();
                }
                return super.getPrimitiveLog();
            }
        };
        if (this.isFireProof()) {
            branch.setFireSpreadSpeed(0).setFlammability(0);
        }
        return branch;
    }

    protected Supplier<BranchBlock> createImbuedBranch(ResourceLocation name) {
        return RegistryHandler.addBlock((ResourceLocation)ResourceLocationUtils.suffix((ResourceLocation)name, (String)this.getBranchNameSuffix()), () -> this.createImbuedBranchBlock(name));
    }

    public Family setPrimitiveImbuedLog(Block primitiveLog) {
        this.primitiveImbuedLog = primitiveLog;
        this.imbuedBranch.get().setPrimitiveLogDrops(new ItemStack[]{new ItemStack((ItemLike)primitiveLog)});
        return this;
    }

    public Optional<BranchBlock> getImbuedBranch() {
        return Optionals.ofBlock((Block)this.imbuedBranch.get());
    }

    public Optional<Block> getPrimitiveImbuedLog() {
        return Optionals.ofBlock((Block)this.primitiveImbuedLog);
    }

    public void generateStateData(DTDataProvider.BlockState provider) {
        super.generateStateData(provider);
        ((ImbuedBranchStateGenerator)((Object)this.imbuedBranchStateGenerator.get())).generate((DTDataProvider)provider, (Object)this);
    }

    public void addBranchTextures(BiConsumer<String, ResourceLocation> textureConsumer, ResourceLocation primitiveLogLocation, Block sourceBlock) {
        Optional<Block> primImbued = this.getPrimitiveImbuedLog();
        if (primImbued.isPresent() && primImbued.get() == sourceBlock) {
            ResourceLocation bark = primitiveLogLocation;
            ResourceLocation rings = ResourceLocationUtils.suffix((ResourceLocation)primitiveLogLocation, (String)"_top");
            if (this.textureOverrides.containsKey("imbued_branch")) {
                bark = (ResourceLocation)this.textureOverrides.get("imbued_branch");
            }
            if (this.textureOverrides.containsKey("imbued_branch_top")) {
                rings = (ResourceLocation)this.textureOverrides.get("imbued_branch_top");
            }
            textureConsumer.accept("bark", bark);
            textureConsumer.accept("rings", rings);
            return;
        }
        super.addBranchTextures(textureConsumer, primitiveLogLocation, sourceBlock);
    }

    public static class ImbuedBranchStateGenerator
    extends BranchStateGenerator {
        @NotNull
        public Generator.Dependencies gatherDependencies(@NotNull Family input) {
            if (input instanceof ImbuedLogFamily) {
                ImbuedLogFamily castedInput = (ImbuedLogFamily)input;
                return new Generator.Dependencies().append(BRANCH, castedInput.getImbuedBranch()).append(PRIMITIVE_LOG, castedInput.getPrimitiveImbuedLog());
            }
            return super.gatherDependencies(input);
        }
    }
}

