/*
 * Decompiled with CFR 0.152.
 */
package maxhyper.dtbwg.trees;

import com.dtteam.dynamictrees.api.registry.TypedRegistry;
import com.dtteam.dynamictrees.block.leaves.LeavesProperties;
import com.dtteam.dynamictrees.tree.family.Family;
import com.dtteam.dynamictrees.tree.species.Species;
import com.dtteam.dynamictrees.tree.species.UndergroundRootsSpecies;
import com.dtteam.dynamictrees.worldgen.DynamicTreeGenerationContext;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockState;

public class MangroveSpecies
extends UndergroundRootsSpecies {
    public static final TypedRegistry.EntryType<Species> TYPE = MangroveSpecies.createDefaultType(MangroveSpecies::new);
    private static final int maxDepth = 4;

    public MangroveSpecies(ResourceLocation name, Family family, LeavesProperties leavesProperties) {
        super(name, family, leavesProperties);
    }

    public boolean isAcceptableSoilForWorldgen(LevelAccessor world, BlockPos pos, BlockState soilBlockState) {
        boolean isAcceptableSoil = this.isAcceptableSoil((LevelReader)world, pos, soilBlockState);
        if (isAcceptableSoil && this.isWater(soilBlockState)) {
            for (int i = 1; i <= 4; ++i) {
                BlockPos down = pos.below(i);
                BlockState downState = world.getBlockState(down);
                if (this.isWater(downState) || !this.isAcceptableSoil((LevelReader)world, down, downState)) continue;
                return true;
            }
            return false;
        }
        return isAcceptableSoil;
    }

    public boolean generate(DynamicTreeGenerationContext context) {
        for (int i = 0; i < 4 && this.isWater(context.level().getBlockState(context.rootPos().below())); ++i) {
            context.rootPos().move(0, -1, 0);
        }
        return super.generate(context);
    }
}

