/*
 * Decompiled with CFR 0.152.
 */
package maxhyper.dtbwg.trees;

import com.dtteam.dynamictrees.api.network.NodeInspector;
import com.dtteam.dynamictrees.api.registry.TypedRegistry;
import com.dtteam.dynamictrees.api.treedata.TreePart;
import com.dtteam.dynamictrees.api.voxmap.SimpleVoxmap;
import com.dtteam.dynamictrees.block.branch.BranchBlock;
import com.dtteam.dynamictrees.block.leaves.LeavesProperties;
import com.dtteam.dynamictrees.tree.TreeHelper;
import com.dtteam.dynamictrees.tree.family.Family;
import com.dtteam.dynamictrees.tree.species.Species;
import maxhyper.dtbwg.cells.DTBWGLeafClusters;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;

public class PoplarSpecies
extends Species {
    public static final TypedRegistry.EntryType<Species> TYPE = PoplarSpecies.createDefaultType(PoplarSpecies::new);

    public PoplarSpecies(ResourceLocation name, Family family, LeavesProperties leavesProperties) {
        super(name, family, leavesProperties);
    }

    public NodeInspector getNodeInflator(SimpleVoxmap leafMap) {
        return new NodeInflatorPoplar(this, leafMap);
    }

    public static class NodeInflatorPoplar
    implements NodeInspector {
        private float radius;
        private BlockPos last;
        Species species;
        SimpleVoxmap leafMap;

        public NodeInflatorPoplar(Species species, SimpleVoxmap leafMap) {
            this.species = species;
            this.leafMap = leafMap;
            this.last = BlockPos.ZERO;
        }

        public boolean run(BlockState state, LevelAccessor level, BlockPos pos, Direction fromDir) {
            BranchBlock branch = TreeHelper.getBranch((BlockState)state);
            if (branch != null) {
                this.radius = this.species.getFamily().getPrimaryThickness();
            }
            return false;
        }

        public boolean returnRun(BlockState state, LevelAccessor level, BlockPos pos, Direction fromDir) {
            BranchBlock branch = TreeHelper.getBranch((BlockState)state);
            if (branch != null) {
                float areaAccum = this.radius * this.radius;
                boolean isTwig = true;
                boolean isTop = level.getBlockState(pos.below()).getBlock() == branch;
                for (Direction dir : Direction.values()) {
                    if (dir.equals((Object)fromDir)) continue;
                    BlockPos dPos = pos.offset(dir.getNormal());
                    if (dPos.equals((Object)this.last)) {
                        isTwig = false;
                        isTop = false;
                        continue;
                    }
                    BlockState deltaBlockState = level.getBlockState(dPos);
                    TreePart treepart = TreeHelper.getTreePart((BlockState)deltaBlockState);
                    if (!branch.isSameTree(treepart)) continue;
                    int branchRadius = treepart.getRadius(deltaBlockState);
                    areaAccum += (float)(branchRadius * branchRadius);
                }
                if (isTop) {
                    this.leafMap.setVoxel(pos, (byte)16);
                    leafCluster = DTBWGLeafClusters.POPLAR_TOP;
                    this.leafMap.blitMax(pos, leafCluster);
                } else if (isTwig) {
                    this.leafMap.setVoxel(pos, (byte)16);
                    leafCluster = this.species.getLeavesProperties().getCellKit().getLeafCluster();
                    this.leafMap.blitMax(pos, leafCluster);
                } else {
                    float secondaryThickness;
                    this.radius = (float)Math.sqrt(areaAccum) + this.species.getTapering() * this.species.getWorldGenTaperingFactor();
                    int maxRadius = this.species.getMaxBranchRadius();
                    if (this.radius > (float)maxRadius) {
                        this.radius = maxRadius;
                    }
                    if (this.radius < (secondaryThickness = (float)this.species.getFamily().getSecondaryThickness())) {
                        this.radius = secondaryThickness;
                    }
                    branch.setRadius(level, pos, (int)Math.floor(this.radius), null);
                    this.leafMap.setVoxel(pos, (byte)32);
                    if (Math.floor(this.radius) < 3.0) {
                        SimpleVoxmap leafCluster = this.species.getLeavesProperties().getCellKit().getLeafCluster();
                        this.leafMap.blitMax(pos, leafCluster);
                    }
                }
                this.last = pos;
            }
            return false;
        }
    }
}

