/*
 * Decompiled with CFR 0.152.
 */
package lib.multiblock.misc;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import lib.multiblock.misc.MultiBlockOffsetPos;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.Rotation;

public class Util {
    public static Rotation DirectionToRotation(Direction direction) {
        return switch (direction) {
            case Direction.NORTH -> Rotation.CLOCKWISE_180;
            case Direction.WEST -> Rotation.CLOCKWISE_90;
            case Direction.EAST -> Rotation.COUNTERCLOCKWISE_90;
            default -> Rotation.NONE;
        };
    }

    public static Map<Character, List<MultiBlockOffsetPos>> parseBlockPattern(List<String[]> aisles, Set<Character> allowedCharacters) {
        int z;
        int x;
        String[] aisle;
        int y;
        Collections.reverse(aisles);
        HashMap<Character, List<MultiBlockOffsetPos>> blockOffsets = new HashMap<Character, List<MultiBlockOffsetPos>>();
        int starX = -1;
        int starY = -1;
        int starZ = -1;
        for (y = 0; y < aisles.size(); ++y) {
            aisle = aisles.get(y);
            block1: for (x = 0; x < aisle.length; ++x) {
                for (z = 0; z < aisle[x].length(); ++z) {
                    if (aisle[x].charAt(z) != '*') continue;
                    starX = x;
                    starY = y;
                    starZ = z;
                    continue block1;
                }
            }
        }
        if (starX == -1 || starY == -1 || starZ == -1) {
            return blockOffsets;
        }
        for (y = 0; y < aisles.size(); ++y) {
            aisle = aisles.get(y);
            for (x = 0; x < aisle.length; ++x) {
                for (z = 0; z < aisle[x].length(); ++z) {
                    char currentChar = aisle[x].charAt(z);
                    if (!allowedCharacters.contains(Character.valueOf(currentChar))) continue;
                    if (!blockOffsets.containsKey(Character.valueOf(currentChar))) {
                        blockOffsets.put(Character.valueOf(currentChar), new ArrayList());
                    }
                    int xOffset = x - starX;
                    int yOffset = y - starY;
                    int zOffset = z - starZ;
                    ((List)blockOffsets.get(Character.valueOf(currentChar))).add(new MultiBlockOffsetPos(currentChar, new BlockPos(xOffset, yOffset, zOffset)));
                }
            }
        }
        return blockOffsets;
    }
}

