/*
 * Decompiled with CFR 0.152.
 */
package net.nuclearteam.createnuclear.content.multiblock.bluePrintItem;

import com.simibubi.create.foundation.networking.SimplePacketBase;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraftforge.network.NetworkEvent;
import net.nuclearteam.createnuclear.content.multiblock.bluePrintItem.ReactorBluePrintMenu;

public class ReactorBluePrintItemPacket
extends SimplePacketBase {
    private final CompoundTag tag;
    private final float heat;
    private final int graphiteTime;
    private final int uraniumTime;
    private final int countGraphiteRod;
    private final int countUraniumRod;
    private double progress;
    private static double totalInit;

    public ReactorBluePrintItemPacket(CompoundTag tag, float heat, int graphiteTime, int uraniumTime, int countGraphiteRod, int countUraniumRod) {
        this.tag = tag;
        this.heat = heat;
        this.graphiteTime = graphiteTime;
        this.uraniumTime = uraniumTime;
        this.countGraphiteRod = countGraphiteRod;
        this.countUraniumRod = countUraniumRod;
        this.progress = ReactorBluePrintItemPacket.calculatePostgres(graphiteTime, countGraphiteRod, uraniumTime, countUraniumRod);
    }

    public ReactorBluePrintItemPacket(CompoundTag tag) {
        this(tag, 0.0f, 3600, 5000, 0, 0);
    }

    public ReactorBluePrintItemPacket(float heat) {
        this(new CompoundTag(), heat, 3600, 5000, 0, 0);
    }

    public ReactorBluePrintItemPacket(int graphiteTime, int uraniumTime, int countGraphiteRod, int countUraniumRod) {
        this(new CompoundTag(), 0.0f, graphiteTime, uraniumTime, countGraphiteRod, countUraniumRod);
    }

    public ReactorBluePrintItemPacket(FriendlyByteBuf buf) {
        this(buf.m_130260_(), buf.readFloat(), buf.readInt(), buf.readInt(), buf.readInt(), buf.readInt());
        this.progress = buf.readDouble();
    }

    public void write(FriendlyByteBuf buffer) {
        buffer.m_130079_(this.tag);
        buffer.writeFloat(this.heat);
        buffer.writeInt(this.graphiteTime);
        buffer.writeInt(this.uraniumTime);
        buffer.writeInt(this.countGraphiteRod);
        buffer.writeInt(this.countUraniumRod);
        buffer.writeDouble(this.progress);
        totalInit = ReactorBluePrintItemPacket.calculateTotalInit(this.countUraniumRod, this.countGraphiteRod);
    }

    public boolean handle(NetworkEvent.Context context) {
        context.enqueueWork(() -> {
            AbstractContainerMenu patt2546$temp;
            ServerPlayer player = context.getSender();
            if (player == null || !((patt2546$temp = player.f_36096_) instanceof ReactorBluePrintMenu)) {
                return;
            }
            ReactorBluePrintMenu c = (ReactorBluePrintMenu)patt2546$temp;
            c.countUraniumRod = this.countUraniumRod;
            c.countGraphiteRod = this.countGraphiteRod;
            c.graphiteTime = this.graphiteTime;
            c.uraniumTime = this.uraniumTime;
            c.progress = this.progress;
            c.heat = this.heat;
            c.sendUpdate = true;
        });
        return true;
    }

    public static double calculatePostgres(int a, int a_exp, int b, int b_exp) {
        double a2 = Math.pow(a, a_exp);
        double b2 = Math.pow(b, b_exp);
        double total = a2 + b2;
        if (Double.isNaN(totalInit)) {
            return total / ReactorBluePrintItemPacket.calculateTotalInit(a, b);
        }
        return total / totalInit;
    }

    public static double calculateTotalInit(int a, int b) {
        return Math.pow(3600.0, a) + Math.pow(5000.0, b);
    }
}

