/*
 * Decompiled with CFR 0.152.
 */
package net.nuclearteam.createnuclear.content.multiblock.controller;

import com.simibubi.create.content.equipment.wrench.IWrenchable;
import com.simibubi.create.foundation.block.IBE;
import com.simibubi.create.foundation.item.ItemHelper;
import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.ChatFormatting;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.items.IItemHandler;
import net.nuclearteam.createnuclear.CNBlockEntityTypes;
import net.nuclearteam.createnuclear.CNBlocks;
import net.nuclearteam.createnuclear.CNItems;
import net.nuclearteam.createnuclear.api.multiblock.BlockPattern;
import net.nuclearteam.createnuclear.api.multiblock.TypeMultiblock;
import net.nuclearteam.createnuclear.content.multiblock.CNMultiblock;
import net.nuclearteam.createnuclear.content.multiblock.controller.ReactorControllerBlockEntity;
import net.nuclearteam.createnuclear.content.multiblock.output.ReactorOutput;
import net.nuclearteam.createnuclear.content.multiblock.output.ReactorOutputEntity;
import net.nuclearteam.createnuclear.foundation.block.HorizontalDirectionalReactorBlock;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class ReactorControllerBlock
extends HorizontalDirectionalReactorBlock
implements IWrenchable,
IBE<ReactorControllerBlockEntity> {
    public static final BooleanProperty ASSEMBLED = BooleanProperty.m_61465_((String)"assembled");

    public ReactorControllerBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING}).m_61104_(new Property[]{ASSEMBLED});
        super.m_7926_(builder);
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_8125_().m_122424_())).m_61124_((Property)ASSEMBLED, (Comparable)Boolean.valueOf(false));
    }

    public void m_6861_(BlockState state, Level worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        this.withBlockEntityDo((BlockGetter)worldIn, pos, be -> {
            be.created = false;
        });
    }

    public InteractionResult m_6227_(BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        if (worldIn.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        BlockEntity blockEntity = worldIn.m_7702_(pos);
        if (!(blockEntity instanceof ReactorControllerBlockEntity)) {
            return InteractionResult.PASS;
        }
        ReactorControllerBlockEntity controllerBlockEntity = (ReactorControllerBlockEntity)blockEntity;
        ItemStack heldItem = player.m_21120_(handIn);
        if (!((Boolean)state.m_61143_((Property)ASSEMBLED)).booleanValue()) {
            player.m_213846_((Component)Component.m_237115_((String)"reactor.info.assembled.none").m_130940_(ChatFormatting.RED));
        } else {
            if (heldItem.m_150930_((Item)CNItems.REACTOR_BLUEPRINT.get()) && controllerBlockEntity.inventory.m_8020_(0).m_41619_()) {
                this.withBlockEntityDo((BlockGetter)worldIn, pos, be -> {
                    be.inventory.setStackInSlot(0, heldItem);
                    be.configuredPattern = heldItem;
                    player.m_21008_(handIn, ItemStack.f_41583_);
                });
                return InteractionResult.SUCCESS;
            }
            if (heldItem.m_41619_() && !controllerBlockEntity.inventory.m_8020_(0).m_41619_()) {
                this.withBlockEntityDo((BlockGetter)worldIn, pos, be -> {
                    player.m_21008_(handIn, be.inventory.m_8020_(0));
                    be.inventory.setStackInSlot(0, ItemStack.f_41583_);
                    be.configuredPattern = ItemStack.f_41583_;
                    be.total = 0.0;
                    be.rotate(be.m_58900_(), new BlockPos(be.m_58899_().m_123341_(), be.m_58899_().m_123342_() + -3, be.m_58899_().m_123343_()), be.m_58904_(), 0);
                    be.notifyUpdate();
                });
                state.m_61124_((Property)ASSEMBLED, (Comparable)Boolean.valueOf(false));
                return InteractionResult.SUCCESS;
            }
            if (!heldItem.m_41619_() && !controllerBlockEntity.inventory.m_8020_(0).m_41619_()) {
                return InteractionResult.PASS;
            }
        }
        return InteractionResult.SUCCESS;
    }

    public void m_6810_(BlockState state, Level worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!state.m_155947_() || state.m_60734_() == newState.m_60734_()) {
            return;
        }
        this.withBlockEntityDo((BlockGetter)worldIn, pos, be -> ItemHelper.dropContents((Level)worldIn, (BlockPos)pos, (IItemHandler)be.inventory));
        worldIn.m_46747_(pos);
        ReactorControllerBlock controller = (ReactorControllerBlock)state.m_60734_();
        controller.Rotate(state, pos.m_6625_(3), worldIn, 0);
        List players = worldIn.m_6907_();
        for (Player p : players) {
            p.m_213846_((Component)Component.m_237115_((String)"reactor.info.assembled.destroyer"));
        }
    }

    public void m_6807_(BlockState state, Level level, BlockPos pos, BlockState oldState, boolean movedByPiston) {
        super.m_6807_(state, level, pos, oldState, movedByPiston);
        if (((Boolean)state.m_61143_((Property)ASSEMBLED)).booleanValue()) {
            return;
        }
        List players = level.m_6907_();
        ReactorControllerBlock controller = (ReactorControllerBlock)state.m_60734_();
        controller.Verify(state, pos, level, players, true);
    }

    public void m_6240_(Level level, Player player, BlockPos pos, BlockState state, @Nullable BlockEntity blockEntity, ItemStack tool) {
        super.m_6240_(level, player, pos, state, blockEntity, tool);
        ReactorControllerBlock controller = (ReactorControllerBlock)state.m_60734_();
        ReactorControllerBlockEntity entity = (ReactorControllerBlockEntity)controller.getBlockEntity((BlockGetter)level, pos);
        if (!entity.created) {
            return;
        }
        controller.Rotate(state, pos.m_6625_(3), level, 0);
        List players = level.m_6907_();
        for (Player p : players) {
            p.m_213846_((Component)Component.m_237115_((String)"reactor.info.assembled.creator"));
        }
    }

    public void Verify(BlockState state, BlockPos pos, Level level, List<? extends Player> players, boolean create) {
        ReactorControllerBlock controller = (ReactorControllerBlock)level.m_8055_(pos).m_60734_();
        ReactorControllerBlockEntity entity = (ReactorControllerBlockEntity)controller.getBlockEntity((BlockGetter)level, pos);
        BlockPattern<TypeMultiblock> result = CNMultiblock.REGISTRATE_MULTIBLOCK.findStructure(level, pos);
        if (result != null) {
            for (Player player : players) {
                if (!create || entity.created) continue;
                player.m_213846_((Component)Component.m_237115_((String)"reactor.info.assembled.creator"));
                level.m_46597_(pos, (BlockState)state.m_61124_((Property)ASSEMBLED, (Comparable)Boolean.valueOf(true)));
                entity.created = true;
                entity.destroyed = false;
            }
            return;
        }
        for (Player player : players) {
            if (create || entity.destroyed) continue;
            player.m_213846_((Component)Component.m_237115_((String)"reactor.info.assembled.destroyer"));
            level.m_46597_(pos, (BlockState)state.m_61124_((Property)ASSEMBLED, (Comparable)Boolean.valueOf(false)));
            entity.created = false;
            entity.destroyed = true;
            this.Rotate(state, pos.m_6625_(3), level, 0);
        }
    }

    public void Rotate(BlockState state, BlockPos pos, Level level, int rotation) {
        if (level.m_8055_(pos).m_60713_((Block)CNBlocks.REACTOR_OUTPUT.get())) {
            ReactorOutput block = (ReactorOutput)level.m_8055_(pos).m_60734_();
            ReactorOutputEntity entity = (ReactorOutputEntity)block.getBlockEntityType().m_58949_((BlockGetter)level, pos);
            if (((Boolean)state.m_61143_((Property)ASSEMBLED)).booleanValue() && rotation != 0) {
                entity.speed = rotation;
                entity.setSpeed(Math.abs(entity.speed));
            } else {
                entity.setSpeed(0);
                entity.speed = 0;
            }
            entity.updateSpeed = true;
            entity.updateGeneratedRotation();
            entity.setSpeed(rotation);
        }
    }

    public Class<ReactorControllerBlockEntity> getBlockEntityClass() {
        return ReactorControllerBlockEntity.class;
    }

    public BlockEntityType<? extends ReactorControllerBlockEntity> getBlockEntityType() {
        return (BlockEntityType)CNBlockEntityTypes.REACTOR_CONTROLLER.get();
    }
}

