/*
 * Decompiled with CFR 0.152.
 */
package net.nuclearteam.createnuclear.content.multiblock.frame;

import com.simibubi.create.content.equipment.wrench.IWrenchable;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.nuclearteam.createnuclear.CNBlocks;
import net.nuclearteam.createnuclear.content.multiblock.controller.ReactorControllerBlock;
import net.nuclearteam.createnuclear.foundation.utility.CreateNuclearLang;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ReactorFrame
extends Block
implements IWrenchable {
    public static final Property<Part> PART = EnumProperty.m_61587_((String)"part", Part.class);

    public ReactorFrame(BlockBehaviour.Properties properties) {
        super(properties);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{PART});
        super.m_7926_(builder);
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        Level level = context.m_43725_();
        BlockPos pos = context.m_8083_();
        Direction.Axis axis = context.m_43719_().m_122434_();
        if (axis == Direction.Axis.X || axis == Direction.Axis.Z) {
            axis = Direction.Axis.Y;
        }
        return (BlockState)this.m_49966_().m_61124_(PART, (Comparable)((Object)this.getType(this.m_49966_(), this.getRelativeTop(level, pos, axis), this.getRelativeBottom(level, pos, axis))));
    }

    public void m_6861_(BlockState state, Level level, BlockPos pos, Block neighborBlock, BlockPos neighborPos, boolean movedByPiston) {
        if (level.f_46443_) {
            return;
        }
        Direction.Axis axis = Direction.Axis.Y;
        Part part = this.getType(state, this.getRelativeTop(level, pos, axis), this.getRelativeBottom(level, pos, axis));
        if (state.m_61143_(PART) == part) {
            return;
        }
        state = (BlockState)state.m_61124_(PART, (Comparable)((Object)part));
        level.m_7731_(pos, state, 3);
    }

    public BlockState getRelativeTop(Level level, BlockPos pos, Direction.Axis axis) {
        return level.m_8055_(pos.m_121945_(Direction.m_122387_((Direction.Axis)axis, (Direction.AxisDirection)Direction.AxisDirection.POSITIVE)));
    }

    public BlockState getRelativeBottom(Level level, BlockPos pos, Direction.Axis axis) {
        return level.m_8055_(pos.m_121945_(Direction.m_122387_((Direction.Axis)axis, (Direction.AxisDirection)Direction.AxisDirection.NEGATIVE)));
    }

    public Part getType(BlockState state, BlockState above, BlockState below) {
        boolean shapeAboveSame = above.m_60713_(state.m_60734_());
        boolean shapeBelowSame = below.m_60713_(state.m_60734_());
        if (shapeAboveSame && !shapeBelowSame) {
            return Part.END;
        }
        if (!shapeAboveSame && shapeBelowSame) {
            return Part.START;
        }
        if (shapeAboveSame) {
            return Part.MIDDLE;
        }
        return Part.NONE;
    }

    public BlockState rotate(BlockState state, LevelAccessor level, BlockPos pos, Rotation direction) {
        return super.rotate(state, level, pos, direction);
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return super.m_6943_(state, mirror);
    }

    public void m_6807_(BlockState state, Level level, BlockPos pos, BlockState oldState, boolean movedByPiston) {
        super.m_6807_(state, level, pos, oldState, movedByPiston);
        List players = level.m_6907_();
        this.FindController(pos, level, players, true);
    }

    public void m_6240_(Level level, Player player, BlockPos pos, BlockState state, @Nullable BlockEntity blockEntity, ItemStack tool) {
        super.m_6240_(level, player, pos, state, blockEntity, tool);
        List players = level.m_6907_();
        this.FindController(pos, level, players, false);
    }

    public ReactorControllerBlock FindController(BlockPos blockPos, Level level, List<? extends Player> players, boolean first) {
        Vec3i pos = new Vec3i(blockPos.m_123341_(), blockPos.m_123342_(), blockPos.m_123343_());
        for (int y = pos.m_123342_() - 3; y != pos.m_123342_() + 4; ++y) {
            for (int x = pos.m_123341_() - 5; x != pos.m_123341_() + 5; ++x) {
                for (int z = pos.m_123343_() - 5; z != pos.m_123343_() + 5; ++z) {
                    BlockPos newBlock = new BlockPos(x, y, z);
                    if (!level.m_8055_(newBlock).m_60713_((Block)CNBlocks.REACTOR_CONTROLLER.get())) continue;
                    ReactorControllerBlock controller = (ReactorControllerBlock)level.m_8055_(newBlock).m_60734_();
                    controller.Verify(level.m_8055_(newBlock), newBlock, level, players, first);
                    return controller;
                }
            }
        }
        return null;
    }

    public static enum Part implements StringRepresentable
    {
        START,
        MIDDLE,
        END,
        NONE;


        @NotNull
        public String m_7912_() {
            return CreateNuclearLang.asId((String)this.name());
        }
    }
}

