/*
 * Decompiled with CFR 0.152.
 */
package net.nuclearteam.createnuclear.foundation.item;

import com.tterrag.registrate.util.entry.ItemEntry;
import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.function.Function;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;

public class DyedItemsList<T extends Item>
implements Iterable<ItemEntry<T>> {
    private static final int COLOR_AMOUNT = DyeColor.values().length;
    private final ItemEntry<?>[] values = new ItemEntry[COLOR_AMOUNT];

    public DyedItemsList(Function<DyeColor, ItemEntry<? extends T>> filter) {
        for (DyeColor color : DyeColor.values()) {
            this.values[color.ordinal()] = filter.apply(color);
        }
    }

    public ItemEntry<T> get(DyeColor color) {
        return this.values[color.ordinal()];
    }

    public boolean contains(Item item) {
        for (ItemEntry<?> entry : this.values) {
            if (!entry.is(item)) continue;
            return true;
        }
        return false;
    }

    public ItemEntry<T>[] toArray() {
        return Arrays.copyOf(this.values, this.values.length);
    }

    @Override
    public Iterator<ItemEntry<T>> iterator() {
        return new Iterator<ItemEntry<T>>(){
            private int index = 0;

            @Override
            public boolean hasNext() {
                return this.index < DyedItemsList.this.values.length;
            }

            @Override
            public ItemEntry<T> next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return DyedItemsList.this.values[this.index++];
            }
        };
    }
}

