/*
 * Decompiled with CFR 0.152.
 */
package net.nuclearteam.createnuclear.infrastructure.data;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.simibubi.create.foundation.utility.FilesHelper;
import com.tterrag.registrate.providers.ProviderType;
import com.tterrag.registrate.providers.RegistrateLangProvider;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import net.createmod.ponder.api.registration.PonderPlugin;
import net.createmod.ponder.foundation.PonderIndex;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.data.event.GatherDataEvent;
import net.nuclearteam.createnuclear.CreateNuclear;
import net.nuclearteam.createnuclear.foundation.advancement.CNAdvancement;
import net.nuclearteam.createnuclear.foundation.data.recipe.CNMechanicalCraftingRecipeGen;
import net.nuclearteam.createnuclear.foundation.data.recipe.CNProcessingRecipeGen;
import net.nuclearteam.createnuclear.foundation.data.recipe.CNStandardRecipeGen;
import net.nuclearteam.createnuclear.foundation.ponder.CreateNuclearPonderPlugin;
import net.nuclearteam.createnuclear.infrastructure.data.CreateNuclearRegistrateTags;
import net.nuclearteam.createnuclear.infrastructure.data.GeneratedEntriesProvider;

public class CreateNuclearDatagen {
    public static void gatherData(GatherDataEvent event) {
        CreateNuclearDatagen.addExtraRegistrateData();
        DataGenerator generator = event.getGenerator();
        PackOutput output = generator.getPackOutput();
        CompletableFuture lookupProvider = event.getLookupProvider();
        ExistingFileHelper existingFileHelper = event.getExistingFileHelper();
        GeneratedEntriesProvider generatedEntriesProvider = new GeneratedEntriesProvider(output, lookupProvider);
        lookupProvider = generatedEntriesProvider.getRegistryProvider();
        generator.addProvider(event.includeClient(), (DataProvider)generatedEntriesProvider);
        generator.addProvider(event.includeClient(), (DataProvider)new CNStandardRecipeGen(output));
        generator.addProvider(event.includeClient(), (DataProvider)new CNMechanicalCraftingRecipeGen(output));
        generator.addProvider(event.includeClient(), (DataProvider)new CNAdvancement(output));
        if (event.includeServer()) {
            CNProcessingRecipeGen.registerAll(generator, output);
        }
    }

    private static void addExtraRegistrateData() {
        CreateNuclearRegistrateTags.addGenerators();
        CreateNuclear.REGISTRATE.addDataGenerator(ProviderType.LANG, provider -> {
            BiConsumer<String, String> langConsumer = (arg_0, arg_1) -> ((RegistrateLangProvider)provider).add(arg_0, arg_1);
            CreateNuclearDatagen.provideDefaultLang("interface", langConsumer);
            CreateNuclearDatagen.provideDefaultLang("potion", langConsumer);
            CreateNuclearDatagen.provideDefaultLang("tooltips", langConsumer);
            CreateNuclearDatagen.provideDefaultLang("reactor", langConsumer);
            CNAdvancement.provideLang(langConsumer);
            CreateNuclearDatagen.providePonderLang(langConsumer);
        });
    }

    private static void provideDefaultLang(String fileName, BiConsumer<String, String> consumer) {
        String path = "assets/createnuclear/lang/default/" + fileName + ".json";
        JsonElement jsonElement = FilesHelper.loadJsonResource((String)path);
        if (jsonElement == null) {
            throw new IllegalStateException(String.format("Could not find default lang file: %s", path));
        }
        JsonObject jsonObject = jsonElement.getAsJsonObject();
        for (Map.Entry entry : jsonObject.entrySet()) {
            String key = (String)entry.getKey();
            String value = ((JsonElement)entry.getValue()).getAsString();
            consumer.accept(key, value);
        }
    }

    private static void providePonderLang(BiConsumer<String, String> consumer) {
        PonderIndex.addPlugin((PonderPlugin)new CreateNuclearPonderPlugin());
        PonderIndex.getLangAccess().provideLang("createnuclear", consumer);
    }
}

