/*
 * Decompiled with CFR 0.152.
 */
package net.nuclearteam.createnuclear;

import com.simibubi.create.AllFluids;
import com.tterrag.registrate.builders.FluidBuilder;
import com.tterrag.registrate.util.entry.FluidEntry;
import java.util.List;
import java.util.function.Supplier;
import net.createmod.catnip.theme.Color;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.TagKey;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.neoforged.neoforge.common.NeoForgeMod;
import net.neoforged.neoforge.common.SoundActions;
import net.neoforged.neoforge.event.entity.living.LivingEvent;
import net.neoforged.neoforge.fluids.BaseFlowingFluid;
import net.neoforged.neoforge.fluids.FluidInteractionRegistry;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.FluidType;
import net.nuclearteam.createnuclear.CNEffects;
import net.nuclearteam.createnuclear.CNTags;
import net.nuclearteam.createnuclear.CreateNuclear;
import net.nuclearteam.createnuclear.content.decoration.palettes.CNPaletteStoneTypes;
import org.joml.Vector3f;

public class CNFluids {
    public static final FluidEntry<BaseFlowingFluid.Flowing> URANIUM = ((FluidBuilder)CreateNuclear.REGISTRATE.standardFluid("uranium", SolidRenderedPlaceableFluidity.create(3735304, () -> Float.valueOf(0.03125f))).lang("Liquid Uranium").tag(new TagKey[]{CNTags.CNFluidTags.URANIUM.tag}).properties(p -> p.viscosity(2500).density(1600).canSwim(false).sound(SoundActions.BUCKET_FILL, SoundEvents.BUCKET_FILL_LAVA).sound(SoundActions.BUCKET_EMPTY, SoundEvents.BUCKET_EMPTY_LAVA).canDrown(false)).fluidProperties(f -> f.levelDecreasePerBlock(2).tickRate(15).slopeFindDistance(6).explosionResistance(100.0f)).source(BaseFlowingFluid.Source::new).bucket().tag(new TagKey[]{CNTags.forgeItemTag("buckets/uranium")}).lang("Uranium Bucket").build()).register();

    public static void register() {
    }

    public static void handleFluidEffect(LivingEvent.LivingVisibilityEvent event) {
        LivingEntity entity = event.getEntity();
        if (entity.isAlive() && !entity.isSpectator()) {
            if (entity.tickCount % 20 == 0) {
                return;
            }
            if (entity.isInFluidType(URANIUM.getType())) {
                entity.addEffect(new MobEffectInstance(CNEffects.RADIATION.getDelegate(), 100, 0));
            }
        }
    }

    public static void registerFluidInteractions() {
        Supplier<BlockState> autuniteState = () -> ((Block)CNPaletteStoneTypes.AUTUNITE.getBaseBlock().get()).defaultBlockState();
        FluidType uraniumType = ((BaseFlowingFluid.Flowing)URANIUM.get()).getFluidType();
        List<FluidType> sourceFluids = List.of((FluidType)NeoForgeMod.LAVA_TYPE.value(), (FluidType)NeoForgeMod.WATER_TYPE.value());
        for (FluidType source : sourceFluids) {
            FluidInteractionRegistry.addInteraction((FluidType)source, (FluidInteractionRegistry.InteractionInformation)new FluidInteractionRegistry.InteractionInformation(uraniumType, fs -> (BlockState)autuniteState.get()));
        }
    }

    private static class SolidRenderedPlaceableFluidity
    extends AllFluids.TintedFluidType {
        private Vector3f fogColor;
        private Supplier<Float> fogDistance;

        public static FluidBuilder.FluidTypeFactory create(int fogColor, Supplier<Float> fogDistance) {
            return (p, s, f) -> {
                SolidRenderedPlaceableFluidity fluidtype = new SolidRenderedPlaceableFluidity(p, s, f);
                fluidtype.fogColor = new Color(fogColor, false).asVectorF();
                fluidtype.fogDistance = fogDistance;
                return fluidtype;
            };
        }

        private SolidRenderedPlaceableFluidity(FluidType.Properties properties, ResourceLocation stillTecture, ResourceLocation flowingTexture) {
            super(properties, stillTecture, flowingTexture);
        }

        protected int getTintColor(FluidStack stack) {
            return -1;
        }

        protected int getTintColor(FluidState state, BlockAndTintGetter getter, BlockPos pos) {
            return 3735304;
        }

        protected Vector3f getCustomFogColor() {
            return this.fogColor;
        }

        protected float getFogDistanceModifier() {
            return this.fogDistance.get().floatValue();
        }
    }
}

