/*
 * Decompiled with CFR 0.152.
 */
package net.nuclearteam.createnuclear.content.contraptions.irradiated.cat;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.mojang.math.MethodsReturnNonnullByDefault;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.AABB;
import net.nuclearteam.createnuclear.CreateNuclear;
import net.nuclearteam.createnuclear.content.contraptions.irradiated.CNModelLayers;
import net.nuclearteam.createnuclear.content.contraptions.irradiated.cat.IrradiatedCat;
import net.nuclearteam.createnuclear.content.contraptions.irradiated.cat.IrradiatedCatModel;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class IrradiatedCatRenderer
extends MobRenderer<IrradiatedCat, IrradiatedCatModel<IrradiatedCat>> {
    private static final ResourceLocation IRRADIATED_CAT_LOCATION = CreateNuclear.asResource("textures/entity/irradiated_cat.png");

    public IrradiatedCatRenderer(EntityRendererProvider.Context context) {
        super(context, new IrradiatedCatModel(context.bakeLayer(CNModelLayers.IRRADIATED_CAT)), 0.4f);
    }

    public ResourceLocation getTextureLocation(IrradiatedCat entity) {
        return IRRADIATED_CAT_LOCATION;
    }

    protected void scale(IrradiatedCat livingEntity, PoseStack matrixStack, float partialTickTime) {
        super.scale((LivingEntity)livingEntity, matrixStack, partialTickTime);
        matrixStack.scale(0.8f, 0.8f, 0.8f);
    }

    protected void setupRotations(IrradiatedCat entity, PoseStack poseStack, float bob, float yBodyRot, float partialTick, float scale) {
        super.setupRotations((LivingEntity)entity, poseStack, bob, yBodyRot, partialTick, scale);
        float f = entity.getLieDownAmount(partialTick);
        if (f > 0.0f) {
            poseStack.translate(0.4f * f, 0.15f * f, 0.1f * f);
            poseStack.mulPose(Axis.ZP.rotationDegrees(Mth.rotLerp((float)f, (float)0.0f, (float)90.0f)));
            BlockPos blockPos = entity.blockPosition();
            List list = entity.level().getEntitiesOfClass(Player.class, new AABB(blockPos).inflate(2.0, 2.0, 2.0));
            for (Player player : list) {
                if (!player.isSleeping()) continue;
                poseStack.translate(0.15f * f, 0.0f, 0.0f);
                break;
            }
        }
    }
}

