/*
 * Decompiled with CFR 0.152.
 */
package net.nuclearteam.createnuclear.content.enriching.fire;

import com.mojang.serialization.MapCodec;
import com.tterrag.registrate.util.nullness.NonNullUnaryOperator;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseFireBlock;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.nuclearteam.createnuclear.CNTags;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class EnrichingFireBlock
extends BaseFireBlock {
    public static final MapCodec<EnrichingFireBlock> CODEC = EnrichingFireBlock.simpleCodec(EnrichingFireBlock::new);

    public EnrichingFireBlock(BlockBehaviour.Properties properties, float fireDamage) {
        super(properties, fireDamage);
    }

    public EnrichingFireBlock(BlockBehaviour.Properties properties) {
        super(properties, 1.0f);
    }

    protected MapCodec<? extends BaseFireBlock> codec() {
        return CODEC;
    }

    public BlockState getStateForPlacement() {
        return this.defaultBlockState();
    }

    public BlockState updateShape(BlockState pState, Direction pFacing, BlockState pFacingState, LevelAccessor pLevel, BlockPos pCurrentPos, BlockPos pFacingPos) {
        return this.canSurvive(pState, (LevelReader)pLevel, pCurrentPos) ? this.getStateForPlacement() : Blocks.AIR.defaultBlockState();
    }

    public boolean canSurvive(BlockState state, LevelReader worldIn, BlockPos pos) {
        return EnrichingFireBlock.canSurviveOnBlock(worldIn.getBlockState(pos.below()));
    }

    protected boolean canBurn(BlockState p_49284_) {
        return true;
    }

    public static boolean canSurviveOnBlock(BlockState pState) {
        return pState.is(CNTags.CNBlockTags.ENRICHING_FIRE_BASE_BLOCKS.tag);
    }

    public static NonNullUnaryOperator<BlockBehaviour.Properties> getLight() {
        return p -> p.lightLevel(a -> 15);
    }
}

