/*
 * Decompiled with CFR 0.152.
 */
package net.nuclearteam.createnuclear.content.equipment.armor;

import com.simibubi.create.api.data.recipe.BaseRecipeProvider;
import com.simibubi.create.content.equipment.armor.BaseArmorItem;
import com.tterrag.registrate.util.entry.ItemEntry;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.function.Function;
import net.minecraft.core.Holder;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.nuclearteam.createnuclear.CNItems;
import net.nuclearteam.createnuclear.CNTags;
import net.nuclearteam.createnuclear.CreateNuclear;
import net.nuclearteam.createnuclear.content.equipment.armor.CNArmorMaterials;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AntiRadiationArmorItem {
    public static final ArmorItem.Type HELMET = ArmorItem.Type.HELMET;
    public static final ArmorItem.Type CHESTPLATE = ArmorItem.Type.CHESTPLATE;
    public static final ArmorItem.Type LEGGINGS = ArmorItem.Type.LEGGINGS;
    public static final ArmorItem.Type BOOTS = ArmorItem.Type.BOOTS;
    public static final Holder<ArmorMaterial> ARMOR_MATERIAL = CNArmorMaterials.ANTI_RADIATION_SUIT;

    public static enum Armor {
        WHITE_ARMOR(DyeColor.WHITE),
        YELLOW_ARMOR(DyeColor.YELLOW),
        RED_ARMOR(DyeColor.RED),
        BLUE_ARMOR(DyeColor.BLUE),
        GREEN_ARMOR(DyeColor.GREEN),
        BLACK_ARMOR(DyeColor.BLACK),
        ORANGE_ARMOR(DyeColor.ORANGE),
        PURPLE_ARMOR(DyeColor.PURPLE),
        BROWN_ARMOR(DyeColor.BROWN),
        PINK_ARMOR(DyeColor.PINK),
        CYAN_ARMOR(DyeColor.CYAN),
        LIGHT_GRAY_ARMOR(DyeColor.LIGHT_GRAY),
        GRAY_ARMOR(DyeColor.GRAY),
        LIGHT_BLUE_ARMOR(DyeColor.LIGHT_BLUE),
        LIME_ARMOR(DyeColor.LIME),
        MAGENTA_ARMOR(DyeColor.MAGENTA);

        private static final Map<DyeColor, ItemEntry<Helmet>> helmetMap;
        private static final Map<DyeColor, ItemEntry<Chestplate>> chestplateMap;
        private static final Map<DyeColor, ItemEntry<Leggings>> leggingsMap;
        private final DyeColor color;

        private Armor(DyeColor dyeColor) {
            this.color = dyeColor;
        }

        public ItemEntry<Helmet> getHelmetItem() {
            return helmetMap.get(this.color);
        }

        public static ItemEntry<Helmet> getHelmetByColor(DyeColor color) {
            return helmetMap.get(color);
        }

        public ItemEntry<Chestplate> getChestplateItem() {
            return chestplateMap.get(this.color);
        }

        public static ItemEntry<Chestplate> getChestplateByColor(DyeColor color) {
            return chestplateMap.get(color);
        }

        public ItemEntry<Leggings> getLeggingsItem() {
            return leggingsMap.get(this.color);
        }

        public static ItemEntry<Leggings> getLeggingsByColor(DyeColor color) {
            return leggingsMap.get(color);
        }

        public static boolean isArmored(ItemStack item) {
            return helmetMap.values().stream().anyMatch(entry -> entry.is(item.getItem())) || chestplateMap.values().stream().anyMatch(entry -> entry.is(item.getItem())) || leggingsMap.values().stream().anyMatch(entry -> entry.is(item.getItem())) || CNItems.ANTI_RADIATION_BOOTS.is(item.getItem());
        }

        public static boolean isArmored2(ItemStack item) {
            return CNItems.ANTI_RADIATION_HELMETS.contains(item.getItem()) || CNItems.ANTI_RADIATION_CHESTPLATES.contains(item.getItem()) || CNItems.ANTI_RADIATION_LEGGINGS.contains(item.getItem()) || CNItems.ANTI_RADIATION_BOOTS.is(item.getItem());
        }

        static {
            helmetMap = new EnumMap<DyeColor, ItemEntry<Helmet>>(DyeColor.class);
            chestplateMap = new EnumMap<DyeColor, ItemEntry<Chestplate>>(DyeColor.class);
            leggingsMap = new EnumMap<DyeColor, ItemEntry<Leggings>>(DyeColor.class);
            for (DyeColor color : DyeColor.values()) {
                helmetMap.put(color, CNItems.ANTI_RADIATION_HELMETS.get(color));
                chestplateMap.put(color, CNItems.ANTI_RADIATION_CHESTPLATES.get(color));
                leggingsMap.put(color, CNItems.ANTI_RADIATION_LEGGINGS.get(color));
            }
        }
    }

    public static class DyeRecipeArmorList
    implements Iterable<BaseRecipeProvider.GeneratedRecipe> {
        private static final int COLOR_AMOUNT = DyeColor.values().length;
        protected final BaseRecipeProvider.GeneratedRecipe[] recipes = new BaseRecipeProvider.GeneratedRecipe[this.getColorCount()];

        public DyeRecipeArmorList(Function<@NotNull DyeColor, // Could not load outer class - annotation placement on inner may be incorrect
        BaseRecipeProvider.GeneratedRecipe> filler) {
            for (DyeColor color : DyeColor.values()) {
                this.recipes[color.ordinal()] = filler.apply(color);
            }
        }

        protected int getColorCount() {
            return COLOR_AMOUNT;
        }

        public BaseRecipeProvider.GeneratedRecipe get(@Nullable DyeColor color) {
            return this.recipes[color.ordinal()];
        }

        public BaseRecipeProvider.GeneratedRecipe[] toArrays() {
            return Arrays.copyOf(this.recipes, this.recipes.length);
        }

        @Override
        @NotNull
        public Iterator<BaseRecipeProvider.GeneratedRecipe> iterator() {
            return new Iterator<BaseRecipeProvider.GeneratedRecipe>(){
                private int index = 0;

                @Override
                public boolean hasNext() {
                    return this.index < recipes.length;
                }

                @Override
                public BaseRecipeProvider.GeneratedRecipe next() {
                    if (!this.hasNext()) {
                        throw new NoSuchElementException();
                    }
                    return recipes[this.index++];
                }
            };
        }
    }

    public static class Boot
    extends BaseArmorItem {
        public Boot(Item.Properties properties) {
            super(CNArmorMaterials.ANTI_RADIATION_SUIT, BOOTS, properties, CreateNuclear.asResource(String.format(Locale.ROOT, "%s_anti_radiation_suit", DyeColor.WHITE.getName())));
        }
    }

    public static class Leggings
    extends BaseArmorItem {
        protected final DyeColor color;

        public Leggings(Item.Properties properties, DyeColor color) {
            super(CNArmorMaterials.ANTI_RADIATION_SUIT, LEGGINGS, properties, CreateNuclear.asResource(String.format(Locale.ROOT, "%s_anti_radiation_suit", color.getName())));
            this.color = color;
        }

        public static TagKey<Item> getLeggingsTag(String key) {
            return key.equals("white") ? CNTags.CNItemTags.ANTI_RADIATION_ARMOR.tag : CNTags.CNItemTags.ANTI_RADIATION_LEGGINGS_DYE.tag;
        }

        public static class DyeItemLeggingsList<T extends Leggings>
        implements Iterable<ItemEntry<T>> {
            private static final int COLOR_AMOUNT = DyeColor.values().length;
            private final ItemEntry<?>[] entry = new ItemEntry[COLOR_AMOUNT];

            public DyeItemLeggingsList(Function<DyeColor, ItemEntry<? extends T>> filler) {
                for (DyeColor color : DyeColor.values()) {
                    this.entry[color.ordinal()] = filler.apply(color);
                }
            }

            public ItemEntry<T> get(DyeColor color) {
                return this.entry[color.ordinal()];
            }

            public boolean contains(Item block) {
                for (ItemEntry<?> entry : this.entry) {
                    if (!entry.is(block)) continue;
                    return true;
                }
                return false;
            }

            public ItemEntry<T>[] toArray() {
                return Arrays.copyOf(this.entry, this.entry.length);
            }

            @Override
            public Iterator<ItemEntry<T>> iterator() {
                return new Iterator<ItemEntry<T>>(){
                    private int index = 0;

                    @Override
                    public boolean hasNext() {
                        return this.index < entry.length;
                    }

                    @Override
                    public ItemEntry<T> next() {
                        if (!this.hasNext()) {
                            throw new NoSuchElementException();
                        }
                        return entry[this.index++];
                    }
                };
            }
        }
    }

    public static class Chestplate
    extends BaseArmorItem {
        protected final DyeColor color;

        public Chestplate(Item.Properties properties, DyeColor color) {
            super(CNArmorMaterials.ANTI_RADIATION_SUIT, CHESTPLATE, properties, CreateNuclear.asResource(String.format(Locale.ROOT, "%s_anti_radiation_suit", color.getName())));
            this.color = color;
        }

        public static TagKey<Item> getChestplateTag(String key) {
            return key.equals("white") ? CNTags.CNItemTags.ANTI_RADIATION_ARMOR.tag : CNTags.CNItemTags.ANTI_RADIATION_CHESTPLATE_DYE.tag;
        }

        public static class DyeItemChestplateList<T extends Chestplate>
        implements Iterable<ItemEntry<T>> {
            private static final int COLOR_AMOUNT = DyeColor.values().length;
            private final ItemEntry<?>[] entry = new ItemEntry[COLOR_AMOUNT];

            public DyeItemChestplateList(Function<DyeColor, ItemEntry<? extends T>> filler) {
                for (DyeColor color : DyeColor.values()) {
                    this.entry[color.ordinal()] = filler.apply(color);
                }
            }

            public ItemEntry<T> get(DyeColor color) {
                return this.entry[color.ordinal()];
            }

            public boolean contains(Item block) {
                for (ItemEntry<?> entry : this.entry) {
                    if (!entry.is(block)) continue;
                    return true;
                }
                return false;
            }

            public ItemEntry<T>[] toArray() {
                return Arrays.copyOf(this.entry, this.entry.length);
            }

            @Override
            public Iterator<ItemEntry<T>> iterator() {
                return new Iterator<ItemEntry<T>>(){
                    private int index = 0;

                    @Override
                    public boolean hasNext() {
                        return this.index < entry.length;
                    }

                    @Override
                    public ItemEntry<T> next() {
                        if (!this.hasNext()) {
                            throw new NoSuchElementException();
                        }
                        return entry[this.index++];
                    }
                };
            }
        }
    }

    public static class Helmet
    extends BaseArmorItem {
        protected final DyeColor color;

        public Helmet(Item.Properties properties, DyeColor color) {
            super(CNArmorMaterials.ANTI_RADIATION_SUIT, HELMET, properties, CreateNuclear.asResource(String.format(Locale.ROOT, "%s_anti_radiation_suit", color.getName())));
            this.color = color;
        }

        public static TagKey<Item> getHelmetTag(String key) {
            return key.equals("white") ? CNTags.CNItemTags.ANTI_RADIATION_ARMOR.tag : CNTags.CNItemTags.ANTI_RADIATION_HELMET_DYE.tag;
        }

        public static class DyeItemHelmetList<T extends Helmet>
        implements Iterable<ItemEntry<T>> {
            private static final int COLOR_AMOUNT = DyeColor.values().length;
            private final ItemEntry<T>[] entry = new ItemEntry[COLOR_AMOUNT];

            public DyeItemHelmetList(Function<DyeColor, ItemEntry<? extends T>> filler) {
                for (DyeColor color : DyeColor.values()) {
                    this.entry[color.ordinal()] = filler.apply(color);
                }
            }

            public ItemEntry<T> get(DyeColor color) {
                return this.entry[color.ordinal()];
            }

            public boolean contains(Item block) {
                for (ItemEntry<T> entry : this.entry) {
                    if (!entry.is(block)) continue;
                    return true;
                }
                return false;
            }

            public ItemEntry<T>[] toArray() {
                return Arrays.copyOf(this.entry, this.entry.length);
            }

            @Override
            public Iterator<ItemEntry<T>> iterator() {
                return new Iterator<ItemEntry<T>>(){
                    private int index = 0;

                    @Override
                    public boolean hasNext() {
                        return this.index < entry.length;
                    }

                    @Override
                    public ItemEntry<T> next() {
                        if (!this.hasNext()) {
                            throw new NoSuchElementException();
                        }
                        return entry[this.index++];
                    }
                };
            }
        }
    }
}

