/*
 * Decompiled with CFR 0.152.
 */
package net.nuclearteam.createnuclear.content.equipment.cloth;

import com.simibubi.create.api.data.recipe.BaseRecipeProvider;
import com.tterrag.registrate.util.entry.ItemEntry;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.function.Function;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.nuclearteam.createnuclear.CNItems;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClothItem
extends Item {
    private final DyeColor color;

    public ClothItem(Item.Properties properties, DyeColor color) {
        super(properties);
        this.color = color;
    }

    public static enum Cloths {
        WHITE_CLOTH(DyeColor.WHITE),
        YELLOW_CLOTH(DyeColor.YELLOW),
        RED_CLOTH(DyeColor.RED),
        BLUE_CLOTH(DyeColor.BLUE),
        GREEN_CLOTH(DyeColor.GREEN),
        BLACK_CLOTH(DyeColor.BLACK),
        ORANGE_CLOTH(DyeColor.ORANGE),
        PURPLE_CLOTH(DyeColor.PURPLE),
        BROWN_CLOTH(DyeColor.BROWN),
        PINK_CLOTH(DyeColor.PINK),
        CYAN_CLOTH(DyeColor.CYAN),
        LIGHT_GRAY_CLOTH(DyeColor.LIGHT_GRAY),
        GRAY_CLOTH(DyeColor.GRAY),
        LIGHT_BLUE_CLOTH(DyeColor.LIGHT_BLUE),
        LIME_CLOTH(DyeColor.LIME),
        MAGENTA_CLOTH(DyeColor.MAGENTA);

        private static final Map<DyeColor, ItemEntry<ClothItem>> clothMap;
        private final DyeColor color;

        private Cloths(DyeColor color) {
            this.color = color;
        }

        public ItemEntry<ClothItem> getItem() {
            return clothMap.get(this.color);
        }

        public static ItemEntry<ClothItem> getByColor(DyeColor color) {
            return clothMap.get(color);
        }

        static {
            clothMap = new EnumMap<DyeColor, ItemEntry<ClothItem>>(DyeColor.class);
            for (DyeColor color : DyeColor.values()) {
                clothMap.put(color, CNItems.CLOTHS.get(color));
            }
        }
    }

    public static class DyeItemList<T extends Item>
    implements Iterable<ItemEntry<T>> {
        private static final int COLOR_AMOUNT = DyeColor.values().length;
        private final ItemEntry<?>[] entry = new ItemEntry[COLOR_AMOUNT];

        public DyeItemList(Function<DyeColor, ItemEntry<? extends T>> filler) {
            for (DyeColor color : DyeColor.values()) {
                this.entry[color.ordinal()] = filler.apply(color);
            }
        }

        public ItemEntry<T> get(DyeColor color) {
            return this.entry[color.ordinal()];
        }

        public boolean contains(Item block) {
            for (ItemEntry<?> entry : this.entry) {
                if (!entry.is(block)) continue;
                return true;
            }
            return false;
        }

        public ItemEntry<T>[] toArray() {
            return Arrays.copyOf(this.entry, this.entry.length);
        }

        @Override
        public Iterator<ItemEntry<T>> iterator() {
            return new Iterator<ItemEntry<T>>(){
                private int index = 0;

                @Override
                public boolean hasNext() {
                    return this.index < entry.length;
                }

                @Override
                public ItemEntry<T> next() {
                    if (!this.hasNext()) {
                        throw new NoSuchElementException();
                    }
                    return entry[this.index++];
                }
            };
        }
    }

    public static class DyeRecipeList
    implements Iterable<BaseRecipeProvider.GeneratedRecipe> {
        private static final int COLOR_AMOUNT = DyeColor.values().length;
        protected final BaseRecipeProvider.GeneratedRecipe[] recipes = new BaseRecipeProvider.GeneratedRecipe[this.getColorCount()];

        public DyeRecipeList(Function<@NotNull DyeColor, // Could not load outer class - annotation placement on inner may be incorrect
        BaseRecipeProvider.GeneratedRecipe> filler) {
            for (DyeColor color : DyeColor.values()) {
                this.recipes[color.ordinal()] = filler.apply(color);
            }
        }

        protected int getColorCount() {
            return COLOR_AMOUNT;
        }

        public BaseRecipeProvider.GeneratedRecipe get(@Nullable DyeColor color) {
            return this.recipes[color.ordinal()];
        }

        public BaseRecipeProvider.GeneratedRecipe[] toArrays() {
            return Arrays.copyOf(this.recipes, this.recipes.length);
        }

        @Override
        @NotNull
        public Iterator<BaseRecipeProvider.GeneratedRecipe> iterator() {
            return new Iterator<BaseRecipeProvider.GeneratedRecipe>(){
                private int index = 0;

                @Override
                public boolean hasNext() {
                    return this.index < recipes.length;
                }

                @Override
                public BaseRecipeProvider.GeneratedRecipe next() {
                    if (!this.hasNext()) {
                        throw new NoSuchElementException();
                    }
                    return recipes[this.index++];
                }
            };
        }

        public static class NullableDyedRecipeList
        extends DyeRecipeList {
            public NullableDyedRecipeList(Function<@Nullable DyeColor, // Could not load outer class - annotation placement on inner may be incorrect
            BaseRecipeProvider.GeneratedRecipe> filter) {
                super(filter);
                this.recipes[this.recipes.length - 1] = filter.apply(null);
            }

            @Override
            protected int getColorCount() {
                return COLOR_AMOUNT + 1;
            }

            @Override
            public BaseRecipeProvider.GeneratedRecipe get(@Nullable DyeColor color) {
                return color == null ? this.recipes[this.recipes.length - 1] : super.get(color);
            }
        }
    }
}

