/*
 * Decompiled with CFR 0.152.
 */
package net.nuclearteam.createnuclear.content.multiblock.bluePrintItem;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.nuclearteam.createnuclear.CNTags;

public record PatternData(int slot, ItemStack stack) {
    private static final ItemStack DEFAULT_STACK = ItemStack.EMPTY;
    public static final Codec<PatternData> CODEC = RecordCodecBuilder.create(i -> i.group((App)Codec.INT.fieldOf("slot").forGetter(PatternData::slot), (App)ItemStack.CODEC.flatXmap(stack -> {
        if (!stack.isEmpty() || stack.is(CNTags.CNItemTags.FUEL.tag) || stack.is(CNTags.CNItemTags.COOLER.tag)) {
            return DataResult.success((Object)stack);
        }
        return DataResult.success((Object)DEFAULT_STACK);
    }, DataResult::success).fieldOf("Stack").forGetter(PatternData::stack)).apply((Applicative)i, PatternData::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, PatternData> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.INT, PatternData::slot, (StreamCodec)ItemStack.STREAM_CODEC, PatternData::stack, PatternData::new);

    public static ItemStack getDefaultStack() {
        return DEFAULT_STACK;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object o) {
        ItemStack itemStack;
        int slot1;
        if (this == o) {
            return true;
        }
        if (!(o instanceof PatternData)) return false;
        PatternData patternData = (PatternData)o;
        try {
            int n;
            slot1 = n = patternData.slot();
        }
        catch (Throwable throwable) {
            throw new MatchException(throwable.toString(), throwable);
        }
        ItemStack stack1 = itemStack = patternData.stack();
        if (this.slot != slot1) return false;
        if (!ItemStack.isSameItem((ItemStack)this.stack, (ItemStack)stack1)) return false;
        return true;
    }

    @Override
    public int hashCode() {
        return 31 * Integer.hashCode(this.slot) + (this.stack == null ? 0 : this.stack.getItem().hashCode());
    }
}

