/*
 * Decompiled with CFR 0.152.
 */
package net.nuclearteam.createnuclear.content.multiblock.core;

import lib.multiblock.SimpleMultiBlockAislePatternBuilder;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.nuclearteam.createnuclear.CNBlocks;
import net.nuclearteam.createnuclear.content.multiblock.IHeat;
import net.nuclearteam.createnuclear.content.multiblock.casing.ReactorCasingEntity;
import net.nuclearteam.createnuclear.content.multiblock.controller.ReactorControllerBlockEntity;
import net.nuclearteam.createnuclear.infrastructure.config.CNConfigs;

public class ReactorCoreEntity
extends ReactorCasingEntity {
    private int countdownTicks = 0;

    public ReactorCoreEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public void tick() {
        super.tick();
        if (this.level.isClientSide()) {
            return;
        }
        BlockPos controllerPos = this.getBlockPosForReactor();
        BlockEntity blockEntity = this.level.getBlockEntity(controllerPos);
        if (blockEntity instanceof ReactorControllerBlockEntity) {
            ReactorControllerBlockEntity reactorController = (ReactorControllerBlockEntity)blockEntity;
            int heat = reactorController.heat;
            if (IHeat.HeatLevel.of(heat) == IHeat.HeatLevel.DANGER) {
                if (this.countdownTicks >= (Integer)CNConfigs.common().explode.time.get()) {
                    this.explodeReactorCore(this.level, this.getBlockPos());
                } else {
                    ++this.countdownTicks;
                }
            } else {
                this.countdownTicks = 0;
            }
        }
    }

    private void explodeReactorCore(Level world, BlockPos pos) {
        this.level.explode(null, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), 20.0f, Level.ExplosionInteraction.BLOCK);
    }

    private static BlockPos FindController(char character) {
        return SimpleMultiBlockAislePatternBuilder.start().aisle("AAAAA", "AAAAA", "AAAAA", "AAAAA", "AAAAA").aisle("AABAA", "ADADA", "BACAB", "ADADA", "AABAA").aisle("AABAA", "ADADA", "BACAB", "ADADA", "AABAA").aisle("AAIAA", "ADADA", "BACAB", "ADADA", "AA*AA").aisle("AABAA", "ADADA", "BACAB", "ADADA", "AABAA").aisle("AABAA", "ADADA", "BACAB", "ADADA", "AABAA").aisle("AAAAA", "AAAAA", "AAAAA", "AAAAA", "AAOAA").where('A', a -> a.getState().is((Block)CNBlocks.REACTOR_CASING.get())).where('B', a -> a.getState().is((Block)CNBlocks.REACTOR_FRAME.get())).where('C', a -> a.getState().is((Block)CNBlocks.REACTOR_CORE.get())).where('D', a -> a.getState().is((Block)CNBlocks.REACTOR_COOLER.get())).where('*', a -> a.getState().is((Block)CNBlocks.REACTOR_CONTROLLER.get())).where('O', a -> a.getState().is((Block)CNBlocks.REACTOR_OUTPUT.get())).where('I', a -> a.getState().is((Block)CNBlocks.REACTOR_INPUT.get())).getDistanceController(character);
    }

    private BlockPos getBlockPosForReactor() {
        int[][][] directions;
        BlockPos posController = this.getBlockPos();
        BlockPos posInput = new BlockPos(posController.getX(), posController.getY(), posController.getZ());
        int[][][] nArrayArray = directions = new int[][][]{new int[][]{{0, 2, 2}, {0, 1, 2}, {0, 0, 2}, {0, -1, 2}, {0, -2, 2}}, new int[][]{{0, 2, -2}, {0, 1, -2}, {0, 0, -2}, {0, -1, -2}, {0, -2, -2}}, new int[][]{{2, 2, 0}, {2, 1, 0}, {2, 0, 0}, {2, -1, 0}, {2, -2, 0}}, new int[][]{{-2, 2, 0}, {-2, 1, 0}, {-2, 0, 0}, {-2, -1, 0}, {-2, -2, 0}}};
        int n = nArrayArray.length;
        block0: for (int i = 0; i < n; ++i) {
            int[][] direction;
            for (int[] dir : direction = nArrayArray[i]) {
                BlockPos newPos = posController.offset(dir[0], dir[1], dir[2]);
                if (!this.level.getBlockState(newPos).is((Block)CNBlocks.REACTOR_CONTROLLER.get())) continue;
                posInput = newPos;
                continue block0;
            }
        }
        return posInput;
    }
}

