/*
 * Decompiled with CFR 0.152.
 */
package net.nuclearteam.createnuclear.foundation.events.overlay;

import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.LayeredDraw;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.GameType;
import net.nuclearteam.createnuclear.CNEffects;
import net.nuclearteam.createnuclear.CreateNuclear;

public class IrradiatedOverlayRendererVision {
    private static float irradiatedVisionAlpha = 0.0f;
    public static final ResourceLocation IRRADIATED_VISION = CreateNuclear.asResource("textures/misc/irradiated_vision/irradiated_vision.png");

    public static LayeredDraw.Layer getOverlay() {
        return IrradiatedOverlayRendererVision::renderOverlay;
    }

    public static void renderOverlay(GuiGraphics guiGraphics, DeltaTracker deltaTracker) {
        Minecraft mc = Minecraft.getInstance();
        if (mc.options.hideGui || mc.gameMode.getPlayerMode() == GameType.SPECTATOR) {
            return;
        }
        LocalPlayer localPlayer = mc.player;
        RenderSystem.enableBlend();
        irradiatedVisionAlpha = localPlayer.hasEffect(CNEffects.RADIATION.getDelegate()) ? Math.min(1.0f, irradiatedVisionAlpha + 0.01f) : Math.max(0.0f, irradiatedVisionAlpha - 0.01f);
        if (irradiatedVisionAlpha > 0.0f) {
            IrradiatedOverlayRendererVision.renderTextureOverlay(guiGraphics, IRRADIATED_VISION, irradiatedVisionAlpha, true);
        }
    }

    public static void renderTextureOverlay(GuiGraphics guiGraphics, ResourceLocation texture, float alpha, boolean onlyFirstPerson) {
        boolean isFirstPerson = Minecraft.getInstance().options.getCameraType().isFirstPerson();
        if (onlyFirstPerson && !isFirstPerson) {
            return;
        }
        RenderSystem.disableDepthTest();
        RenderSystem.depthMask((boolean)false);
        guiGraphics.setColor(1.0f, 1.0f, 1.0f, alpha);
        guiGraphics.blit(texture, 0, 0, -90, 0.0f, 0.0f, guiGraphics.guiWidth(), guiGraphics.guiHeight(), guiGraphics.guiWidth(), guiGraphics.guiHeight());
        RenderSystem.depthMask((boolean)true);
        RenderSystem.enableDepthTest();
        guiGraphics.setColor(1.0f, 1.0f, 1.0f, 1.0f);
    }
}

