/*
 * Decompiled with CFR 0.152.
 */
package lib.multiblock;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.logging.Level;
import lib.multiblock.impl.IMultiBlockPattern;
import lib.multiblock.misc.MultiBlockOffsetPos;
import lib.multiblock.misc.MultiblockMatchResult;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.TickTask;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.pattern.BlockInWorld;

public final class SimpleMultiBlockPattern
implements IMultiBlockPattern {
    private final List<MultiBlockOffsetPos> multiBlockOffsetPosList;
    private final Map<Character, Predicate<BlockInWorld>> predicateHashMap;
    private final Map<Character, Supplier<BlockState>> blockProvider;

    public SimpleMultiBlockPattern(List<MultiBlockOffsetPos> multiBlockOffsetPosList, Map<Character, Predicate<BlockInWorld>> predicateMap, Map<Character, Supplier<BlockState>> blockSuppliers) {
        this.multiBlockOffsetPosList = List.copyOf(multiBlockOffsetPosList);
        this.predicateHashMap = Map.copyOf(predicateMap);
        this.blockProvider = Map.copyOf(blockSuppliers);
    }

    @Override
    public boolean matches(net.minecraft.world.level.Level level, BlockPos blockPos, Rotation rotation) {
        for (MultiBlockOffsetPos multiBlockOffsetPos : this.multiBlockOffsetPosList) {
            char character = multiBlockOffsetPos.caracter();
            Predicate<BlockInWorld> predicate = this.predicateHashMap.get(Character.valueOf(character));
            BlockInWorld block = new BlockInWorld((LevelReader)level, blockPos.offset((Vec3i)multiBlockOffsetPos.pos().rotate(rotation)), false);
            if (predicate != null && predicate.test(block)) continue;
            return false;
        }
        return true;
    }

    @Override
    public MultiblockMatchResult matchesWithResult(net.minecraft.world.level.Level level, BlockPos blockPos, Rotation rotation) {
        ArrayList<BlockInWorld> result = new ArrayList<BlockInWorld>();
        for (MultiBlockOffsetPos multiBlockOffsetPos : this.multiBlockOffsetPosList) {
            char character = multiBlockOffsetPos.caracter();
            Predicate<BlockInWorld> predicate = this.predicateHashMap.get(Character.valueOf(character));
            BlockInWorld block = new BlockInWorld((LevelReader)level, blockPos.offset((Vec3i)multiBlockOffsetPos.pos().rotate(rotation)), false);
            if (predicate == null || !predicate.test(block)) {
                return null;
            }
            result.add(block);
        }
        return new MultiblockMatchResult(List.copyOf(result));
    }

    @Override
    public void construct(net.minecraft.world.level.Level level, BlockPos blockPos, BiPredicate<Character, BlockState> stateBiPredicate) {
        if (level.isClientSide) {
            return;
        }
        if (level.getServer() == null) {
            return;
        }
        for (MultiBlockOffsetPos multiBlockOffsetPos : this.multiBlockOffsetPosList) {
            char character = multiBlockOffsetPos.caracter();
            Supplier<BlockState> stateSupplier = this.blockProvider.get(Character.valueOf(character));
            if (stateSupplier == null) continue;
            BlockPos pos = blockPos.offset((Vec3i)multiBlockOffsetPos.pos().rotate(Rotation.NONE));
            BlockState state = stateSupplier.get();
            if (!stateBiPredicate.test(Character.valueOf(character), state)) continue;
            level.getServer().tell((Runnable)new TickTask(3, () -> level.setBlock(pos, state, 3)));
        }
    }

    @Override
    public boolean matches(Level level, BlockPos pos, Rotation rotation) {
        return false;
    }

    public List<MultiBlockOffsetPos> test() {
        return this.multiBlockOffsetPosList;
    }
}

