/*
 * Decompiled with CFR 0.152.
 */
package net.nuclearteam.createnuclear;

import net.createmod.catnip.lang.Lang;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.nuclearteam.createnuclear.CreateNuclear;

public class CNTags {
    public static <T> TagKey<T> optionalTag(Registry<T> registry, ResourceLocation id) {
        return TagKey.create((ResourceKey)registry.key(), (ResourceLocation)id);
    }

    public static <T> TagKey<T> forgeTag(Registry<T> registry, String path) {
        return CNTags.optionalTag(registry, ResourceLocation.fromNamespaceAndPath((String)NameSpace.NEO_FORGE.id, (String)path));
    }

    public static TagKey<Block> forgeBlockTag(String path) {
        return CNTags.forgeTag(BuiltInRegistries.BLOCK, path);
    }

    public static TagKey<Item> forgeItemTag(String path) {
        return CNTags.forgeTag(BuiltInRegistries.ITEM, path);
    }

    public static TagKey<Fluid> forgeFluidTag(String path) {
        return CNTags.forgeTag(BuiltInRegistries.FLUID, path);
    }

    public static void init() {
        CreateNuclear.LOGGER.info("Registering mod tags for createnuclear");
        CNBlockTags.init();
        CNItemTags.init();
        CNFluidTags.init();
        CNEntityTags.init();
        CNRecipeSerializerTags.init();
    }

    public static enum NameSpace {
        MOD("createnuclear", false, true),
        COMMON("c"),
        CREATE("create"),
        FORGE("forge"),
        NEO_FORGE(NameSpace.COMMON.id),
        MINECRAFT("minecraft");

        public final String id;
        public final boolean optionalDefault;
        public final boolean alwaysDatagenDefault;

        private NameSpace(String id) {
            this(id, true, false);
        }

        private NameSpace(String id, boolean optionalDefault, boolean alwaysDatagenDefault) {
            this.id = id;
            this.optionalDefault = optionalDefault;
            this.alwaysDatagenDefault = alwaysDatagenDefault;
        }
    }

    public static enum CNBlockTags {
        FAN_PROCESSING_CATALYSTS_ENRICHED(NameSpace.MOD, "fan_processing_catalysts/enriched"),
        ENRICHING_FIRE_BASE_BLOCKS,
        ALL_CAMPFIRES(NameSpace.MINECRAFT, "all/campfires"),
        URANIUM_ORES,
        LEAD_ORES;

        public final TagKey<Block> tag;
        public final boolean alwaysDatagen;

        private CNBlockTags() {
            this(NameSpace.MOD);
        }

        private CNBlockTags(NameSpace namespace) {
            this(namespace, namespace.optionalDefault, namespace.alwaysDatagenDefault);
        }

        private CNBlockTags(NameSpace nameSpace, String path) {
            this(nameSpace, path, nameSpace.optionalDefault, nameSpace.alwaysDatagenDefault);
        }

        private CNBlockTags(NameSpace nameSpace, boolean optional, boolean alwaysDatagenDefault) {
            this(nameSpace, null, optional, alwaysDatagenDefault);
        }

        private CNBlockTags(NameSpace nameSpace, String path, boolean optional, boolean alwaysDatagenDefault) {
            ResourceLocation id = ResourceLocation.fromNamespaceAndPath((String)nameSpace.id, (String)(path == null ? Lang.asId((String)this.name()) : path));
            this.tag = optional ? CNTags.optionalTag(BuiltInRegistries.BLOCK, id) : BlockTags.create((ResourceLocation)id);
            this.alwaysDatagen = alwaysDatagenDefault;
        }

        public boolean matches(Block block) {
            return block.builtInRegistryHolder().is(this.tag);
        }

        public boolean matches(ItemStack stack) {
            BlockItem blockItem;
            Item item;
            return stack != null && (item = stack.getItem()) instanceof BlockItem && this.matches((blockItem = (BlockItem)item).getBlock());
        }

        public boolean matches(BlockState state) {
            return state.is(this.tag);
        }

        private static void init() {
        }
    }

    public static enum CNItemTags {
        CLOTH,
        FUEL,
        COOLER,
        URANIUM_ORES,
        LEAD_ORES,
        ANTI_RADIATION_HELMET_DYE,
        ANTI_RADIATION_CHESTPLATE_DYE,
        ANTI_RADIATION_LEGGINGS_DYE,
        ANTI_RADIATION_BOOTS_DYE,
        ANTI_RADIATION_ARMOR,
        ALL_ANTI_RADIATION_ARMORS,
        ANTI_RADIATION_HELMET_FULL_DYE,
        ANTI_RADIATION_CHESTPLATE_FULL_DYE,
        ANTI_RADIATION_LEGGINGS_FULL_DYE;

        public final TagKey<Item> tag;
        public final boolean alwaysDatagen;

        private CNItemTags() {
            this(NameSpace.MOD);
        }

        private CNItemTags(NameSpace namespace) {
            this(namespace, namespace.optionalDefault, namespace.alwaysDatagenDefault);
        }

        private CNItemTags(NameSpace nameSpace, String path) {
            this(nameSpace, path, nameSpace.optionalDefault, nameSpace.alwaysDatagenDefault);
        }

        private CNItemTags(NameSpace nameSpace, boolean optional, boolean alwaysDatagenDefault) {
            this(nameSpace, null, optional, alwaysDatagenDefault);
        }

        private CNItemTags(NameSpace nameSpace, String path, boolean optional, boolean alwaysDatagenDefault) {
            ResourceLocation id = ResourceLocation.fromNamespaceAndPath((String)nameSpace.id, (String)(path == null ? Lang.asId((String)this.name()) : path));
            this.tag = optional ? CNTags.optionalTag(BuiltInRegistries.ITEM, id) : ItemTags.create((ResourceLocation)id);
            this.alwaysDatagen = alwaysDatagenDefault;
        }

        public boolean matches(Item item) {
            return item.builtInRegistryHolder().is(this.tag);
        }

        public boolean matches(ItemStack stack) {
            return stack.is(this.tag);
        }

        private static void init() {
        }
    }

    public static enum CNFluidTags {
        URANIUM;

        public final TagKey<Fluid> tag;
        public final boolean alwaysDatagen;

        private CNFluidTags() {
            this(NameSpace.MOD);
        }

        private CNFluidTags(NameSpace namespace) {
            this(namespace, namespace.optionalDefault, namespace.alwaysDatagenDefault);
        }

        private CNFluidTags(NameSpace nameSpace, String path) {
            this(nameSpace, path, nameSpace.optionalDefault, nameSpace.alwaysDatagenDefault);
        }

        private CNFluidTags(NameSpace nameSpace, boolean optional, boolean alwaysDatagenDefault) {
            this(nameSpace, null, optional, alwaysDatagenDefault);
        }

        private CNFluidTags(NameSpace nameSpace, String path, boolean optional, boolean alwaysDatagenDefault) {
            ResourceLocation id = ResourceLocation.fromNamespaceAndPath((String)nameSpace.id, (String)(path == null ? Lang.asId((String)this.name()) : path));
            this.tag = optional ? CNTags.optionalTag(BuiltInRegistries.FLUID, id) : FluidTags.create((ResourceLocation)id);
            this.alwaysDatagen = alwaysDatagenDefault;
        }

        public boolean matches(Fluid fluid) {
            return fluid.is(this.tag);
        }

        public boolean matches(FluidState stack) {
            return stack.is(this.tag);
        }

        private static void init() {
        }
    }

    public static enum CNEntityTags {
        IRRADIATED_IMMUNE;

        public final TagKey<EntityType<?>> tag;
        public final boolean alwaysDatagen;

        private CNEntityTags() {
            this(NameSpace.MOD);
        }

        private CNEntityTags(NameSpace nameSpace) {
            this(nameSpace, nameSpace.optionalDefault, nameSpace.alwaysDatagenDefault);
        }

        private CNEntityTags(NameSpace nameSpace, String path) {
            this(nameSpace, path, nameSpace.optionalDefault, nameSpace.alwaysDatagenDefault);
        }

        private CNEntityTags(NameSpace nameSpace, boolean optional, boolean alwaysDatagenDefault) {
            this(nameSpace, null, optional, alwaysDatagenDefault);
        }

        private CNEntityTags(NameSpace nameSpace, String path, boolean optional, boolean alwaysDatagenDefault) {
            ResourceLocation id = ResourceLocation.fromNamespaceAndPath((String)nameSpace.id, (String)(path == null ? Lang.asId((String)this.name()) : path));
            this.tag = optional ? CNTags.optionalTag(BuiltInRegistries.ENTITY_TYPE, id) : TagKey.create((ResourceKey)Registries.ENTITY_TYPE, (ResourceLocation)id);
            this.alwaysDatagen = alwaysDatagenDefault;
        }

        public boolean matches(EntityType<?> type) {
            return type.is(this.tag);
        }

        public boolean matches(Entity entity) {
            return this.matches(entity.getType());
        }

        private static void init() {
        }
    }

    public static enum CNRecipeSerializerTags {
        AUTOMATION_IGNORE;

        public final TagKey<RecipeSerializer<?>> tag;
        public final boolean alwaysDatagen;

        private CNRecipeSerializerTags() {
            this(NameSpace.MOD);
        }

        private CNRecipeSerializerTags(NameSpace namespace) {
            this(namespace, namespace.optionalDefault, namespace.alwaysDatagenDefault);
        }

        private CNRecipeSerializerTags(NameSpace namespace, String path) {
            this(namespace, path, namespace.optionalDefault, namespace.alwaysDatagenDefault);
        }

        private CNRecipeSerializerTags(NameSpace namespace, boolean optional, boolean alwaysDatagen) {
            this(namespace, null, optional, alwaysDatagen);
        }

        private CNRecipeSerializerTags(NameSpace namespace, String path, boolean optional, boolean alwaysDatagen) {
            ResourceLocation id = ResourceLocation.fromNamespaceAndPath((String)namespace.id, (String)(path == null ? Lang.asId((String)this.name()) : path));
            this.tag = optional ? CNTags.optionalTag(BuiltInRegistries.RECIPE_SERIALIZER, id) : TagKey.create((ResourceKey)Registries.RECIPE_SERIALIZER, (ResourceLocation)id);
            this.alwaysDatagen = alwaysDatagen;
        }

        public boolean matches(RecipeSerializer<?> recipeSerializer) {
            ResourceKey key = (ResourceKey)BuiltInRegistries.RECIPE_SERIALIZER.getResourceKey(recipeSerializer).orElseThrow();
            return ((Holder.Reference)BuiltInRegistries.RECIPE_SERIALIZER.getHolder(key).orElseThrow()).is(this.tag);
        }

        private static void init() {
        }
    }
}

