/*
 * Decompiled with CFR 0.152.
 */
package net.nuclearteam.createnuclear.compat.jei;

import com.simibubi.create.AllFluids;
import com.simibubi.create.AllItems;
import com.simibubi.create.compat.jei.BlueprintTransferHandler;
import com.simibubi.create.compat.jei.GhostIngredientHandler;
import com.simibubi.create.compat.jei.PotionFluidSubtypeInterpreter;
import com.simibubi.create.compat.jei.SlotMover;
import com.simibubi.create.compat.jei.StockKeeperTransferHandler;
import com.simibubi.create.compat.jei.ToolboxColoringRecipeMaker;
import com.simibubi.create.compat.jei.category.CreateRecipeCategory;
import com.simibubi.create.compat.jei.category.ProcessingViaFanCategory;
import com.simibubi.create.content.equipment.blueprint.BlueprintScreen;
import com.simibubi.create.content.fluids.potion.PotionFluid;
import com.simibubi.create.content.logistics.factoryBoard.FactoryPanelSetItemScreen;
import com.simibubi.create.content.logistics.filter.AbstractFilterScreen;
import com.simibubi.create.content.logistics.redstoneRequester.RedstoneRequesterScreen;
import com.simibubi.create.content.redstone.link.controller.LinkedControllerScreen;
import com.simibubi.create.content.trains.schedule.ScheduleScreen;
import com.simibubi.create.foundation.gui.menu.AbstractSimiContainerScreen;
import com.simibubi.create.foundation.item.ItemHelper;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.RecipeTypes;
import mezz.jei.api.gui.handlers.IGhostIngredientHandler;
import mezz.jei.api.gui.handlers.IGuiContainerHandler;
import mezz.jei.api.helpers.IPlatformFluidHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.subtypes.ISubtypeInterpreter;
import mezz.jei.api.neoforge.NeoForgeTypes;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandler;
import mezz.jei.api.recipe.transfer.IUniversalRecipeTransferHandler;
import mezz.jei.api.registration.IExtraIngredientRegistration;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.IRecipeTransferRegistration;
import mezz.jei.api.registration.ISubtypeRegistration;
import mezz.jei.api.runtime.IIngredientManager;
import mezz.jei.api.runtime.IJeiRuntime;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.fluids.FluidStack;
import net.nuclearteam.createnuclear.CNBlocks;
import net.nuclearteam.createnuclear.CNRecipeTypes;
import net.nuclearteam.createnuclear.CreateNuclear;
import net.nuclearteam.createnuclear.compat.jei.category.FanEnrichedCategory;
import net.nuclearteam.createnuclear.content.kinetics.fan.processing.EnrichedRecipe;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
@JeiPlugin
public class CreateNuclearJEI
implements IModPlugin {
    private static final ResourceLocation ID = CreateNuclear.asResource("jei_plugin");
    private final List<CreateRecipeCategory<?>> allCategories = new ArrayList();
    private IIngredientManager ingredientManager;
    public static IJeiRuntime runtime;

    private void loadCategories() {
        this.allCategories.clear();
        CreateRecipeCategory enriched = this.builder(EnrichedRecipe.class).addTypedRecipes(CNRecipeTypes.ENRICHED::getType).catalystStack(ProcessingViaFanCategory.getFan((String)"fan_enriched")).doubleItemIcon((ItemLike)AllItems.PROPELLER.get(), (ItemLike)CNBlocks.ENRICHING_CAMPFIRE.get()).emptyBackground(178, 72).build("fan_enriched", FanEnrichedCategory::new);
    }

    private <T extends Recipe<? extends RecipeInput>> CategoryBuilder<T> builder(Class<T> recipeClass) {
        return new CategoryBuilder<T>(recipeClass);
    }

    @Nonnull
    public ResourceLocation getPluginUid() {
        return ID;
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        this.loadCategories();
        registration.addRecipeCategories((IRecipeCategory[])this.allCategories.toArray(IRecipeCategory[]::new));
    }

    public void registerRecipes(IRecipeRegistration registration) {
        this.ingredientManager = registration.getIngredientManager();
        this.allCategories.forEach(c -> c.registerRecipes(registration));
        registration.addRecipes(RecipeTypes.CRAFTING, ToolboxColoringRecipeMaker.createRecipes().toList());
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        this.allCategories.forEach(c -> c.registerCatalysts(registration));
    }

    public void registerRecipeTransferHandlers(IRecipeTransferRegistration registration) {
        registration.addRecipeTransferHandler((IRecipeTransferHandler)new BlueprintTransferHandler(), RecipeTypes.CRAFTING);
        registration.addUniversalRecipeTransferHandler((IUniversalRecipeTransferHandler)new StockKeeperTransferHandler(registration.getJeiHelpers()));
    }

    public <T> void registerFluidSubtypes(ISubtypeRegistration registration, IPlatformFluidHelper<T> platformFluidHelper) {
        PotionFluidSubtypeInterpreter interpreter = new PotionFluidSubtypeInterpreter();
        PotionFluid potionFluid = (PotionFluid)AllFluids.POTION.get();
        registration.registerSubtypeInterpreter(NeoForgeTypes.FLUID_STACK, (Object)potionFluid.getSource(), (ISubtypeInterpreter)interpreter);
        registration.registerSubtypeInterpreter(NeoForgeTypes.FLUID_STACK, (Object)potionFluid.getFlowing(), (ISubtypeInterpreter)interpreter);
    }

    public void registerExtraIngredients(IExtraIngredientRegistration registration) {
        RegistryAccess registryAccess = Minecraft.getInstance().level.registryAccess();
        List potions = registryAccess.lookupOrThrow(Registries.POTION).listElements().toList();
        ArrayList<FluidStack> potionFluids = new ArrayList<FluidStack>(potions.size() * 3);
        HashSet visitedEffects = new HashSet();
        for (Holder.Reference potion : potions) {
            PotionContents potionContents = new PotionContents((Holder)potion);
            if (potionContents.hasEffects()) {
                HashSet effectSet = new HashSet();
                potionContents.forEachEffect(mei -> effectSet.add(mei.getEffect()));
                if (!visitedEffects.add(effectSet)) continue;
            }
            potionFluids.add(PotionFluid.of((int)1000, (PotionContents)potionContents, (PotionFluid.BottleType)PotionFluid.BottleType.REGULAR));
        }
        registration.addExtraIngredients((IIngredientType)NeoForgeTypes.FLUID_STACK, potionFluids);
    }

    public void registerGuiHandlers(IGuiHandlerRegistration registration) {
        registration.addGenericGuiContainerHandler(AbstractSimiContainerScreen.class, (IGuiContainerHandler)new SlotMover());
        registration.addGhostIngredientHandler(AbstractFilterScreen.class, (IGhostIngredientHandler)new GhostIngredientHandler());
        registration.addGhostIngredientHandler(BlueprintScreen.class, (IGhostIngredientHandler)new GhostIngredientHandler());
        registration.addGhostIngredientHandler(LinkedControllerScreen.class, (IGhostIngredientHandler)new GhostIngredientHandler());
        registration.addGhostIngredientHandler(ScheduleScreen.class, (IGhostIngredientHandler)new GhostIngredientHandler());
        registration.addGhostIngredientHandler(RedstoneRequesterScreen.class, (IGhostIngredientHandler)new GhostIngredientHandler());
        registration.addGhostIngredientHandler(FactoryPanelSetItemScreen.class, (IGhostIngredientHandler)new GhostIngredientHandler());
    }

    public static void consumeAllRecipes(Consumer<? super RecipeHolder<?>> consumer) {
        Minecraft.getInstance().getConnection().getRecipeManager().getRecipes().forEach(consumer);
    }

    public static <T extends Recipe<?>> void consumeTypedRecipes(Consumer<RecipeHolder<?>> consumer, RecipeType<?> type) {
        List map = Minecraft.getInstance().getConnection().getRecipeManager().getAllRecipesFor(type);
        if (!map.isEmpty()) {
            map.forEach(consumer);
        }
    }

    public static List<RecipeHolder<?>> getTypedRecipes(RecipeType<?> type) {
        ArrayList recipes = new ArrayList();
        CreateNuclearJEI.consumeTypedRecipes(recipes::add, type);
        return recipes;
    }

    public static List<RecipeHolder<?>> getTypedRecipesExcluding(RecipeType<?> type, Predicate<RecipeHolder<?>> exclusionPred) {
        List<RecipeHolder<?>> recipes = CreateNuclearJEI.getTypedRecipes(type);
        recipes.removeIf(exclusionPred);
        return recipes;
    }

    public static boolean doInputsMatch(Recipe<?> recipe1, Recipe<?> recipe2) {
        if (recipe1.getIngredients().isEmpty() || recipe2.getIngredients().isEmpty()) {
            return false;
        }
        ItemStack[] matchingStacks = ((Ingredient)recipe1.getIngredients().getFirst()).getItems();
        if (matchingStacks.length == 0) {
            return false;
        }
        return ((Ingredient)recipe2.getIngredients().getFirst()).test(matchingStacks[0]);
    }

    public static boolean doOutputsMatch(Recipe<?> recipe1, Recipe<?> recipe2) {
        RegistryAccess registryAccess = Minecraft.getInstance().level.registryAccess();
        return ItemHelper.sameItem((ItemStack)recipe1.getResultItem((HolderLookup.Provider)registryAccess), (ItemStack)recipe2.getResultItem((HolderLookup.Provider)registryAccess));
    }

    public void onRuntimeAvailable(IJeiRuntime runtime) {
        CreateNuclearJEI.runtime = runtime;
    }

    private class CategoryBuilder<T extends Recipe<?>>
    extends CreateRecipeCategory.Builder<T> {
        public CategoryBuilder(Class<? extends T> recipeClass) {
            super(recipeClass);
        }

        public CreateRecipeCategory<T> build(ResourceLocation id, CreateRecipeCategory.Factory<T> factory) {
            CreateRecipeCategory category = super.build(id, factory);
            CreateNuclearJEI.this.allCategories.add(category);
            return category;
        }
    }
}

