/*
 * Decompiled with CFR 0.152.
 */
package net.nuclearteam.createnuclear.content.contraptions.irradiated.cat;

import net.minecraft.core.BlockPos;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.MoveToBlockGoal;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FurnaceBlock;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BedPart;
import net.minecraft.world.level.block.state.properties.Property;
import net.nuclearteam.createnuclear.content.contraptions.irradiated.cat.IrradiatedCat;

public class IrradiatedCatSitOnBlockGoal
extends MoveToBlockGoal {
    private final IrradiatedCat irradiatedCat;

    public IrradiatedCatSitOnBlockGoal(IrradiatedCat cat, double speedModifier) {
        super((PathfinderMob)cat, speedModifier, 8);
        this.irradiatedCat = cat;
    }

    public boolean canUse() {
        return this.irradiatedCat.isTame() && !this.irradiatedCat.isOrderedToSit() && super.canUse();
    }

    public void start() {
        super.start();
        this.irradiatedCat.setInSittingPose(false);
    }

    public void stop() {
        super.stop();
        this.irradiatedCat.setInSittingPose(false);
    }

    public void tick() {
        super.tick();
        this.irradiatedCat.setInSittingPose(this.isReachedTarget());
    }

    protected boolean isValidTarget(LevelReader level, BlockPos pos) {
        if (!level.isEmptyBlock(pos.above())) {
            return false;
        }
        BlockState blockstate = level.getBlockState(pos);
        if (blockstate.is(Blocks.CHEST)) {
            return ChestBlockEntity.getOpenCount((BlockGetter)level, (BlockPos)pos) < 1;
        }
        return blockstate.is(Blocks.FURNACE) && (Boolean)blockstate.getValue((Property)FurnaceBlock.LIT) != false || blockstate.is(BlockTags.BEDS, p_25156_ -> p_25156_.getOptionalValue((Property)BedBlock.PART).map(p_148084_ -> p_148084_ != BedPart.HEAD).orElse(true));
    }
}

