/*
 * Decompiled with CFR 0.152.
 */
package net.nuclearteam.createnuclear.content.contraptions.irradiated.wolf;

import java.util.EnumSet;
import javax.annotation.Nullable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.nuclearteam.createnuclear.content.contraptions.irradiated.wolf.IrradiatedWolf;

public class BegGoal
extends Goal {
    private final IrradiatedWolf irradiatedWolf;
    @Nullable
    private Player player;
    private final Level level;
    private final float lookDistance;
    private int lookTime;
    private final TargetingConditions begTargeting;

    public BegGoal(IrradiatedWolf wolf, float lookDistance) {
        this.irradiatedWolf = wolf;
        this.level = wolf.level();
        this.lookDistance = lookDistance;
        this.begTargeting = TargetingConditions.forNonCombat().range((double)lookDistance);
        this.setFlags(EnumSet.of(Goal.Flag.LOOK));
    }

    public boolean canUse() {
        this.player = this.level.getNearestPlayer(this.begTargeting, (LivingEntity)this.irradiatedWolf);
        return this.player == null ? false : this.playerHoldingInteresting(this.player);
    }

    public boolean canContinueToUse() {
        if (!this.player.isAlive()) {
            return false;
        }
        return !(this.irradiatedWolf.distanceToSqr((Entity)this.player) > (double)(this.lookDistance * this.lookDistance)) && this.lookTime > 0 && this.playerHoldingInteresting(this.player);
    }

    public void start() {
        this.irradiatedWolf.setIsInterested(true);
        this.lookTime = this.adjustedTickDelay(40 + this.irradiatedWolf.getRandom().nextInt(40));
    }

    public void stop() {
        this.irradiatedWolf.setIsInterested(false);
        this.player = null;
    }

    public void tick() {
        this.irradiatedWolf.getLookControl().setLookAt(this.player.getX(), this.player.getEyeY(), this.player.getZ(), 10.0f, (float)this.irradiatedWolf.getMaxHeadXRot());
        --this.lookTime;
    }

    private boolean playerHoldingInteresting(Player player) {
        for (InteractionHand interactionhand : InteractionHand.values()) {
            ItemStack itemstack = player.getItemInHand(interactionhand);
            if (!itemstack.is(Items.BONE) && !this.irradiatedWolf.isFood(itemstack)) continue;
            return true;
        }
        return false;
    }
}

