/*
 * Decompiled with CFR 0.152.
 */
package net.nuclearteam.createnuclear.content.multiblock.frame;

import com.simibubi.create.content.equipment.wrench.IWrenchable;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.nuclearteam.createnuclear.CNBlocks;
import net.nuclearteam.createnuclear.content.multiblock.controller.ReactorControllerBlock;
import net.nuclearteam.createnuclear.foundation.utility.CreateNuclearLang;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ReactorFrame
extends Block
implements IWrenchable {
    public static final Property<Part> PART = EnumProperty.create((String)"part", Part.class);

    public ReactorFrame(BlockBehaviour.Properties properties) {
        super(properties);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{PART});
        super.createBlockStateDefinition(builder);
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        Level level = context.getLevel();
        BlockPos pos = context.getClickedPos();
        Direction.Axis axis = context.getClickedFace().getAxis();
        if (axis == Direction.Axis.X || axis == Direction.Axis.Z) {
            axis = Direction.Axis.Y;
        }
        return (BlockState)this.defaultBlockState().setValue(PART, (Comparable)((Object)this.getType(this.defaultBlockState(), this.getRelativeTop(level, pos, axis), this.getRelativeBottom(level, pos, axis))));
    }

    public void neighborChanged(BlockState state, Level level, BlockPos pos, Block neighborBlock, BlockPos neighborPos, boolean movedByPiston) {
        if (level.isClientSide) {
            return;
        }
        Direction.Axis axis = Direction.Axis.Y;
        Part part = this.getType(state, this.getRelativeTop(level, pos, axis), this.getRelativeBottom(level, pos, axis));
        if (state.getValue(PART) == part) {
            return;
        }
        state = (BlockState)state.setValue(PART, (Comparable)((Object)part));
        level.setBlock(pos, state, 3);
    }

    public BlockState getRelativeTop(Level level, BlockPos pos, Direction.Axis axis) {
        return level.getBlockState(pos.relative(Direction.fromAxisAndDirection((Direction.Axis)axis, (Direction.AxisDirection)Direction.AxisDirection.POSITIVE)));
    }

    public BlockState getRelativeBottom(Level level, BlockPos pos, Direction.Axis axis) {
        return level.getBlockState(pos.relative(Direction.fromAxisAndDirection((Direction.Axis)axis, (Direction.AxisDirection)Direction.AxisDirection.NEGATIVE)));
    }

    public Part getType(BlockState state, BlockState above, BlockState below) {
        boolean shapeAboveSame = above.is(state.getBlock());
        boolean shapeBelowSame = below.is(state.getBlock());
        if (shapeAboveSame && !shapeBelowSame) {
            return Part.END;
        }
        if (!shapeAboveSame && shapeBelowSame) {
            return Part.START;
        }
        if (shapeAboveSame) {
            return Part.MIDDLE;
        }
        return Part.NONE;
    }

    public BlockState rotate(BlockState state, LevelAccessor level, BlockPos pos, Rotation direction) {
        return super.rotate(state, level, pos, direction);
    }

    public BlockState mirror(BlockState state, Mirror mirror) {
        return super.mirror(state, mirror);
    }

    public void onPlace(BlockState state, Level level, BlockPos pos, BlockState oldState, boolean movedByPiston) {
        super.onPlace(state, level, pos, oldState, movedByPiston);
        List players = level.players();
        this.FindController(pos, level, players, true);
    }

    public void playerDestroy(Level level, Player player, BlockPos pos, BlockState state, @Nullable BlockEntity blockEntity, ItemStack tool) {
        super.playerDestroy(level, player, pos, state, blockEntity, tool);
        List players = level.players();
        this.FindController(pos, level, players, false);
    }

    public ReactorControllerBlock FindController(BlockPos blockPos, Level level, List<? extends Player> players, boolean first) {
        Vec3i pos = new Vec3i(blockPos.getX(), blockPos.getY(), blockPos.getZ());
        for (int y = pos.getY() - 3; y != pos.getY() + 4; ++y) {
            for (int x = pos.getX() - 5; x != pos.getX() + 5; ++x) {
                for (int z = pos.getZ() - 5; z != pos.getZ() + 5; ++z) {
                    BlockPos newBlock = new BlockPos(x, y, z);
                    if (!level.getBlockState(newBlock).is((Block)CNBlocks.REACTOR_CONTROLLER.get())) continue;
                    ReactorControllerBlock controller = (ReactorControllerBlock)level.getBlockState(newBlock).getBlock();
                    controller.Verify(level.getBlockState(newBlock), newBlock, level, players, first);
                    return controller;
                }
            }
        }
        return null;
    }

    public static enum Part implements StringRepresentable
    {
        START,
        MIDDLE,
        END,
        NONE;


        @NotNull
        public String getSerializedName() {
            return CreateNuclearLang.asId((String)this.name());
        }
    }
}

