/*
 * Decompiled with CFR 0.152.
 */
package co.secretonline.accessiblestep.config;

import blue.endless.jankson.Jankson;
import blue.endless.jankson.JsonObject;
import blue.endless.jankson.api.SyntaxError;
import co.secretonline.accessiblestep.AccessibleStepCommon;
import co.secretonline.accessiblestep.config.AccessibleStepConfig;
import co.secretonline.accessiblestep.config.migration.MigrateFromOptionsTxt;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Path;

public class AccessibleStepConfigReader {
    private final String configPath;
    private final Path gameDir;

    public AccessibleStepConfigReader(Path configDir) {
        this.configPath = String.format("%s/%s.json", configDir, "accessible-step");
        this.gameDir = configDir.getParent();
    }

    public AccessibleStepConfig readConfig() {
        File configFile = new File(this.configPath);
        if (!configFile.exists()) {
            AccessibleStepCommon.LOGGER.info(String.format("Creating config file for %s.", "accessible-step"));
            AccessibleStepConfig config = MigrateFromOptionsTxt.readConfig(this.gameDir);
            if (config == null) {
                config = new AccessibleStepConfig();
            }
            this.writeConfig(config);
            return config;
        }
        try {
            Jankson jankson = Jankson.builder().build();
            JsonObject configJson = jankson.load(configFile);
            return (AccessibleStepConfig)jankson.fromJson(configJson, AccessibleStepConfig.class);
        }
        catch (SyntaxError | IOException err) {
            AccessibleStepCommon.LOGGER.error(String.format("Unable to read config file. Revering to default settings.", new Object[0]));
            return new AccessibleStepConfig();
        }
    }

    public void writeConfig(AccessibleStepConfig config) {
        File configFile = new File(this.configPath);
        if (!configFile.exists()) {
            try {
                configFile.createNewFile();
            }
            catch (IOException e) {
                AccessibleStepCommon.LOGGER.error(String.format("Unable to create config file. Pending changes will be lost.", new Object[0]));
                return;
            }
        }
        Jankson jankson = Jankson.builder().build();
        String result = jankson.toJson((Object)config).toJson(true, true);
        try {
            FileOutputStream out = new FileOutputStream(configFile, false);
            out.write(result.getBytes());
            out.flush();
            out.close();
        }
        catch (IOException err) {
            AccessibleStepCommon.LOGGER.error(String.format("Unable to save config file. Pending changes will be lost.", new Object[0]));
        }
    }
}

