/*
 * Decompiled with CFR 0.152.
 */
package co.secretonline.accessiblestep.config.migration;

import blue.endless.jankson.Jankson;
import blue.endless.jankson.JsonObject;
import co.secretonline.accessiblestep.AccessibleStepCommon;
import co.secretonline.accessiblestep.StepMode;
import co.secretonline.accessiblestep.config.AccessibleStepConfig;
import com.google.common.base.Splitter;
import com.google.common.io.Files;
import java.io.BufferedReader;
import java.io.File;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.Iterator;
import org.jetbrains.annotations.Nullable;

public class MigrateFromOptionsTxt {
    private static final Splitter COLON_SPLITTER = Splitter.on((char)':').limit(2);
    private static AccessibleStepConfig.WorldConfig defaultValues = new AccessibleStepConfig.WorldConfig();
    public String accessibleStep;
    public boolean accessibleStepFullRange;
    public double accessibleStepHeight;
    public double accessibleSneakHeight;
    public double accessibleSprintHeight;

    public MigrateFromOptionsTxt() {
        this.accessibleStep = MigrateFromOptionsTxt.defaultValues.stepMode.method_15434();
        this.accessibleStepFullRange = MigrateFromOptionsTxt.defaultValues.useFullRange;
        this.accessibleStepHeight = MigrateFromOptionsTxt.defaultValues.stepHeight;
        this.accessibleSneakHeight = MigrateFromOptionsTxt.defaultValues.sneakHeight;
        this.accessibleSprintHeight = MigrateFromOptionsTxt.defaultValues.sprintHeight;
    }

    @Nullable
    public static AccessibleStepConfig readConfig(Path gameDirectory) {
        File optionsTxt = new File(gameDirectory.toString(), "options.txt");
        try {
            if (!optionsTxt.exists()) {
                return null;
            }
            Jankson jankson = Jankson.builder().build();
            JsonObject options = new JsonObject();
            try (BufferedReader bufferedReader = Files.newReader((File)optionsTxt, (Charset)StandardCharsets.UTF_8);){
                bufferedReader.lines().forEach(line -> {
                    try {
                        Iterator iterator = COLON_SPLITTER.split((CharSequence)line).iterator();
                        String key = (String)iterator.next();
                        String value = (String)iterator.next();
                        if (value.isEmpty()) {
                            return;
                        }
                        options.put(key, jankson.loadElement(value));
                    }
                    catch (Exception err) {
                        AccessibleStepCommon.LOGGER.warn("Migration: Skipping bad option: {}", line);
                    }
                });
            }
            catch (Throwable err) {
                AccessibleStepCommon.LOGGER.warn("Migration: Stopped while parsing options.txt", err);
            }
            if (!options.containsKey((Object)"accessibleStep")) {
                return null;
            }
            MigrateFromOptionsTxt parsedOptions = (MigrateFromOptionsTxt)jankson.fromJson(options, MigrateFromOptionsTxt.class);
            AccessibleStepConfig config = new AccessibleStepConfig();
            config.defaultConfig.stepMode = StepMode.bySerialisedId(parsedOptions.accessibleStep);
            config.defaultConfig.useFullRange = parsedOptions.accessibleStepFullRange;
            config.defaultConfig.stepHeight = parsedOptions.accessibleStepHeight;
            config.defaultConfig.sneakHeight = parsedOptions.accessibleSneakHeight;
            config.defaultConfig.sprintHeight = parsedOptions.accessibleSprintHeight;
            return config;
        }
        catch (Exception err) {
            AccessibleStepCommon.LOGGER.error("Migration: Failed to migrate options from options.txt, will reset to default", (Throwable)err);
            return null;
        }
    }
}

