/*
 * Decompiled with CFR 0.152.
 */
package co.secretonline.accessiblestep.screen;

import co.secretonline.accessiblestep.Constants;
import co.secretonline.accessiblestep.State;
import co.secretonline.accessiblestep.StepMode;
import co.secretonline.accessiblestep.screen.AccessibleStepOptionsScreen;
import com.mojang.serialization.Codec;
import java.util.Arrays;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_437;
import net.minecraft.class_7172;
import net.minecraft.class_7919;

public class AccessibleStepOptions {
    public static final double MIN_STEP_HEIGHT = 0.0;
    public static final double MAX_STEP_HEIGHT_NORMAL = 2.5;
    public static final double MAX_STEP_HEIGHT_FULL = 10.0;
    private static final double STEP_HEIGHT_INCREMENTS_PER_BLOCK = 20.0;
    private static final class_2561 STEP_MODE_OFF_TOOLTIP = class_2561.method_43471((String)"options.accessiblestep.off.tooltip");
    private static final class_2561 STEP_MODE_STEP_TOOLTIP = class_2561.method_43471((String)"options.accessiblestep.step.tooltip");
    private static final class_2561 STEP_MODE_AUTO_JUMP_TOOLTIP = class_2561.method_43471((String)"options.accessiblestep.autojump.tooltip");
    private static final class_2561 PER_WORLD_TOOLTIP = class_2561.method_43471((String)"options.accessiblestep.perworld.tooltip");
    private static final class_2561 FULL_RANGE_TOOLTIP = class_2561.method_43471((String)"options.accessiblestep.fullrange.tooltip");
    private static final class_2561 STEP_HEIGHT_TOOLTIP = class_2561.method_43471((String)"options.accessiblestep.height.tooltip");
    private static final class_2561 SNEAK_HEIGHT_TOOLTIP = class_2561.method_43471((String)"options.accessiblestep.sneakheight.tooltip");
    private static final class_2561 SPRINT_HEIGHT_TOOLTIP = class_2561.method_43471((String)"options.accessiblestep.sprintheight.tooltip");
    private static final class_7172<StepMode> stepModeOption = new class_7172("options.accessiblestep.mode", AccessibleStepOptions::getStepModeTooltip, (component, stepMode) -> class_2561.method_43471((String)stepMode.getKey()), (class_7172.class_7178)new class_7172.class_7173(Arrays.asList(StepMode.values()), StepMode.CODEC), (Object)StepMode.OFF, AccessibleStepOptions::onStepModeChange);
    private static final class_7172<Boolean> perWorldOption = class_7172.method_41750((String)"options.accessiblestep.perworld", value -> class_7919.method_47407((class_2561)PER_WORLD_TOOLTIP), (boolean)false, AccessibleStepOptions::onPerWorldChange);
    private static final class_7172<Boolean> fullRangeOption = class_7172.method_41750((String)"options.accessiblestep.fullrange", value -> class_7919.method_47407((class_2561)FULL_RANGE_TOOLTIP), (boolean)false, AccessibleStepOptions::onFullRangeChange);
    private static final class_7172<Double> stepHeightOption = new class_7172("options.accessiblestep.height", value -> class_7919.method_47407((class_2561)STEP_HEIGHT_TOOLTIP), AccessibleStepOptions::getStepHeightText, (class_7172.class_7178)class_7172.class_7177.field_37875.method_42420(AccessibleStepOptions::toStepHeight, AccessibleStepOptions::fromStepHeight), Codec.doubleRange((double)0.0, (double)10.0), (Object)1.25, value -> State.config.setStepHeight((double)value));
    private static final class_7172<Double> sneakHeightOption = new class_7172("options.accessiblestep.sneakheight", value -> class_7919.method_47407((class_2561)SNEAK_HEIGHT_TOOLTIP), AccessibleStepOptions::getStepHeightText, (class_7172.class_7178)class_7172.class_7177.field_37875.method_42420(AccessibleStepOptions::toStepHeight, AccessibleStepOptions::fromStepHeight), Codec.doubleRange((double)0.0, (double)10.0), (Object)Constants.MOD_DEFAULT_SNEAK_HEIGHT, value -> State.config.setSneakHeight((double)value));
    private static final class_7172<Double> sprintHeightOption = new class_7172("options.accessiblestep.sprintheight", value -> class_7919.method_47407((class_2561)SPRINT_HEIGHT_TOOLTIP), AccessibleStepOptions::getStepHeightText, (class_7172.class_7178)class_7172.class_7177.field_37875.method_42420(AccessibleStepOptions::toStepHeight, AccessibleStepOptions::fromStepHeight), Codec.doubleRange((double)0.0, (double)10.0), (Object)1.25, value -> State.config.setSprintHeight((double)value));

    private static class_7919 getStepModeTooltip(StepMode value) {
        switch (value) {
            case OFF: {
                return class_7919.method_47407((class_2561)STEP_MODE_OFF_TOOLTIP);
            }
            case STEP: {
                return class_7919.method_47407((class_2561)STEP_MODE_STEP_TOOLTIP);
            }
            case AUTO_JUMP: {
                return class_7919.method_47407((class_2561)STEP_MODE_AUTO_JUMP_TOOLTIP);
            }
        }
        throw new IncompatibleClassChangeError();
    }

    private static void onStepModeChange(StepMode value) {
        State.config.setStepMode(value);
    }

    private static void onPerWorldChange(Boolean value) {
        State.config.setHasConfigForWorld(value);
        class_310 client = class_310.method_1551();
        class_437 class_4372 = client.field_1755;
        if (class_4372 instanceof AccessibleStepOptionsScreen) {
            AccessibleStepOptionsScreen optionsScreen = (AccessibleStepOptionsScreen)class_4372;
            optionsScreen.resetOptionsForWorld();
        }
    }

    private static void onFullRangeChange(Boolean value) {
        State.config.setFullRange(value);
        class_310 client = class_310.method_1551();
        class_437 class_4372 = client.field_1755;
        if (class_4372 instanceof AccessibleStepOptionsScreen) {
            AccessibleStepOptionsScreen optionsScreen = (AccessibleStepOptionsScreen)class_4372;
            optionsScreen.rescaleStepHeightSliders();
        }
    }

    private static double toStepHeight(double rangeValue) {
        double currentMaxHeight = (Boolean)fullRangeOption.method_41753() != false ? 10.0 : 2.5;
        return AccessibleStepOptions.toStepHeight(rangeValue, currentMaxHeight);
    }

    private static double toStepHeight(double rangeValue, double maxValue) {
        double mappedValue = rangeValue * maxValue;
        return Math.floor(mappedValue * 20.0) / 20.0;
    }

    private static double fromStepHeight(double stepHeight) {
        double currentMaxHeight = (Boolean)fullRangeOption.method_41753() != false ? 10.0 : 2.5;
        return AccessibleStepOptions.fromStepHeight(stepHeight, currentMaxHeight);
    }

    private static double fromStepHeight(double stepHeight, double maxValue) {
        return stepHeight / maxValue;
    }

    private static class_2561 getStepHeightText(class_2561 optionText, Double value) {
        return class_2561.method_43469((String)"options.generic_value", (Object[])new Object[]{optionText, value});
    }

    public static class_7172<StepMode> getStepModeOption() {
        stepModeOption.method_41748((Object)State.config.getStepMode());
        return stepModeOption;
    }

    public static class_7172<Boolean> getPerWorldOption() {
        perWorldOption.method_41748((Object)State.config.hasConfigForWorld());
        return perWorldOption;
    }

    public static class_7172<Boolean> getFullRangeOption() {
        fullRangeOption.method_41748((Object)State.config.getFullRange());
        return fullRangeOption;
    }

    public static class_7172<Double> getStepHeightOption() {
        stepHeightOption.method_41748((Object)State.config.getStepHeight());
        return stepHeightOption;
    }

    public static class_7172<Double> getSneakHeightOption() {
        sneakHeightOption.method_41748((Object)State.config.getSneakHeight());
        return sneakHeightOption;
    }

    public static class_7172<Double> getSprintHeightOption() {
        sprintHeightOption.method_41748((Object)State.config.getSprintHeight());
        return sprintHeightOption;
    }
}

